<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        <?php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($restore != 0): ?>
                        <li><a href="<?php echo e(route('restore')); ?>" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        <?php endif; ?>
                        


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                         <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">User Access Control</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    
                                        <div class="row">
                                            <div class="col s3">
                                                <div class="dropdown2">
                                                    <a href="#modal4" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                                </div>
                                                
                                            </div>
                                            <div class="col s6">
                                            </div>
                                            <div class="col s3">
                                                <?php
                                                    $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'User Access Control')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_create');
                                                ?>
                                                <?php if($create == 1): ?>
                                                <a class="waves-effect waves-light btn indigo right modal-trigger" href="#modal1">Create New User</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php if(session('register')): ?>
                                            <script>
                                                alert('Email / UserName / IC No already exist.', 'TEST');
                                            </script>
                                        <?php endif; ?>
                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Name</th>
                                                    <th>Username</th>
                                                    <th>User Role</th>
                                                    <th>Department</th>
                                                    <th class="center">Active User</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php
                                                    $no = 1;
                                                ?>
                                                <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $users): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($no); ?></td>
                                                    <td><?php echo e($users->name); ?></td>
                                                    <td><?php echo e($users->username); ?> </td>
                                                    <td class="data-row" data-role="<?php echo e($users->ur_name); ?>"><?php echo e($users->ur_name); ?> </td>
                                                    <td class="data-row2" data-department="<?php echo e($users->department_name); ?>"><?php echo e($users->department_name); ?> </td>
                                                    <td class="center">
                                                            <?php if($users->is_active == 1): ?>
                                                            
                                                            Yes
                                                            <?php else: ?>
                                                            
                                                            No
                                                            <?php endif; ?>
                                                            <span></span>
                                                        </label>
                                                    </td>
                                                    <td class="center">
                                                        <?php
                                                            $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'User Access Control')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_update');
                                                            $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'User Access Control')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_delete');
                                                        ?>
                                                        <?php if($update == 1): ?>
                                                        <a href="<?php echo e(route('edit-user', $users->id)); ?>"><span class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit" ></i></span></a>
                                                        <?php endif; ?>
                                                        <?php if($delete == 1): ?>
                                                        <span class="label label-ready tooltipped sa-delete" data-user-id="<?php echo e($users->id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                    $no++;
                                                ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        

<!-- Modal Add Supplier -->
<div id="modal1" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">New User</h4>
	<form id="form" method="POST" action="<?php echo e(route('add-user')); ?>">
    <?php echo csrf_field(); ?>
		<div class="row">
            <div class="input-field col s12 l6">
                <h6 class="labelform">Name</h6>
                <input id="name" name="name" type="text" required>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Username</h6>
                <input id="username" name="username" type="text" required>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">IC No</h6>
                <input id="icno" name="ic_no" type="text" maxlength="14" required>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Email</h6>
                <input id="email" name="email" type="text" required>
            </div>
            <div class="input-field col s12 l5">
                <h6 class="labelform">Password</h6>
                <input id="password" name="password" type="password" required>
                

            </div>
            <div class="input-field col s12 l1 bottom">
                <br><br>
                <i class="fas fa-eye-slash" id="toggle-password"></i>

            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">User Role</h6>
                <select id="role" name="role" required>
                <?php $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($roles->ur_id); ?>"><?php echo e($roles->ur_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l12">
                <h6 class="labelform">Department</h6>
                <select id="department" name="department" required>
                <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($dpt->department_id); ?>"><?php echo e($dpt->department_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="add-user" class="waves-effect waves-light btn indigo right">Register</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Filter Modal-->
<div id="modal4" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Filter User Access Control</h4>
	<form method="GET" action="<?php echo e(route('usercontrol')); ?>" id="form">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="input-field col s12 l6">
                <h6 class="labelform">Name</h6>
                <select id="name" name="name">
                <option value="" selected>No Name Selected</option>
                <?php $__currentLoopData = $filter_name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($name); ?>"><?php echo e($name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Username</h6>
                <select id="username" name="username">
                <option value="" selected>No Username Selected</option>
                <?php $__currentLoopData = $filter_username; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $username): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($username); ?>"><?php echo e($username); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">User Role</h6>
                <select id="role" name="role">
                <option value="" selected>No Role Selected</option>
                <?php $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($roles->ur_id); ?>"><?php echo e($roles->ur_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Active User</h6>
                <select id="active" name="active">
                <option value="" selected>No Role Selected</option>
                <option value="1">Yes</option>
                <option value="0">No</option>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Department</h6>
                <select id="department" name="department">
                <option value="" selected>No Department Selected</option>
                <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($dpt->department_id); ?>"><?php echo e($dpt->department_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                    <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();

    });

    $(document).ready(function() {
        $('#add-user').click(function() {
            event.preventDefault(); // Prevent form submission by default

            // Check if all required inputs are filled
            var isFormValid = true;
            $('#form input[required]').each(function() {
                if ($(this).val() === '') {
                isFormValid = false;
                return false; // Exit the loop if an empty required input is found
                }
            });

            if(isFormValid){
                var addButton = $(this); // Store the reference to the delete button
                swal({
                    title: "Are you sure?",
                    text: "Are you sure want to add new user?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    closeOnConfirm: false
                    }).then((result) => {
                    if (result.value) {
                        addButton.closest("form").submit();
                    }
                    });
            } else {
                alert("Please fill all the field.");
            }

        });
    });

    $('.sa-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This user will be permanently delete! Alternatively, you may choose to deactivate this user first.",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('user-id');
            var deleteUrl = "<?php echo e(route('delete-user', ['id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

<script>
    //IC No Format
    const icnoInput = document.getElementById("icno");

    icnoInput.addEventListener("input", function (event) {
        let icno = event.target.value.replace(/[^0-9]/g, ""); // Remove any non-numeric characters
        if (icno.length > 12) {
            icno = icno.slice(0, 12);
        } else if (icno.length > 6) {
            icno = icno.slice(0, 6) + "-" + icno.slice(6, 8) + "-" + icno.slice(8, 12);
        } else if (icno.length > 4) {
            icno = icno.slice(0, 4) + "-" + icno.slice(4, 6);
        }

        event.target.value = icno;
    });

</script>

<script>
   // Function to filter the table rows based on the selected role
    function filterTableByRole() {
        const selectedRole = document.getElementById("roleFilter").value;
        const dataRows = document.getElementsByClassName("data-row");

        for (let row of dataRows) {
            const rowRole = row.getAttribute("data-role");
            if (selectedRole === "All" || selectedRole === rowRole) {
                row.parentElement.style.display = "";
            } else {
                row.parentElement.style.display = "none";
            }
        }
    }

    document.getElementById("roleFilter").addEventListener("change", filterTableByRole);
    filterTableByRole();

</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const passwordInput = document.getElementById('password');
        const togglePasswordIcon = document.getElementById('toggle-password');

        togglePasswordIcon.addEventListener('click', function() {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                togglePasswordIcon.classList.remove('fa-eye-slash');
                togglePasswordIcon.classList.add('fa-eye');
            } else {
                passwordInput.type = 'password';
                togglePasswordIcon.classList.remove('fa-eye');
                togglePasswordIcon.classList.add('fa-eye-slash');
            }
        });
    });
</script>





</body>
</html>

<?php /**PATH /home/demo6861/public_html/hiroseinventory/resources/views/useraccesscontrol.blade.php ENDPATH**/ ?>