

<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/favicon.png')); ?>">
        <title>HRS - Inventory</title>
        <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/pages/authentication.css')); ?>" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <!-- Preloader -->
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url(<?php echo e(asset('images/big/auth-bg.jpg')); ?>) no-repeat center center;">
                <div class="auth-box">
                    <!-- Forgot Password --> 
                    <div id="">
                        <div class="logo">
                            
                            <h5 class="font-medium m-b-20">Reset Password</h5>
                            <span>Please enter your last 4 digit IC number</span>
                        </div>
                        <div class="row">
                            <form class="col s12" action="<?php echo e(route('reset-pass')); ?>" method="GET">
                                <div class="row">
                                    <div class="input-field col s12">
                                        <input id="email1" type="number" class="validate" name="ic_no" placeholder="Last 4 digit IC number" required autofocus>
                                    </div>
                                </div>

                                 <!-- Error message -->
                                 <?php if($errors->any()): ?>
                                 <div class="alert alert-danger">
                                     <center><ul>
                                         <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li class="red-text">We can't find any last 4 digit IC number</li>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     </ul></center>
                                 </div>
                                 <?php endif; ?>

                                <div class="row m-t-20">
                                    <div class="col s12">
                                        <center>
                                            <button type="submit" class="btn-large w100 red" name="action">Submit</button><p></p>
                                            <a href="<?php echo e(route('supply')); ?>" class="link">Back</a>
                                        </center>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
        <script>
        $(function() {
        $(".preloader").fadeOut();
        });
        </script>
    </body>
</html><?php /**PATH C:\xampp\htdocs\HIROSE\HiroseInventory2\resources\views/auth/resetpass.blade.php ENDPATH**/ ?>