<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }
    </style>
    
</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="light-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="47%">
                            
                        </span>
                        
                    </a>

                    <ul class="right">
                        
                        <li><a href="" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger tooltipped" data-tooltip="Profile" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                         <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Restore</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    <div class="card">
                                        <div class="card-tabs">
                                            <ul class="tabs">
                                                <li class="tab"><a class="active" href="#test11">Supplier</a></li>
                                                <li class="tab"><a href="#test12">Spare Part</a></li>
                                                <li class="tab"><a href="#test13">Stock In/Out</a></li>
                                                <li class="tab"><a href="#test14">Budgeting</a></li>
                                                <li class="tab"><a href="#test15">Department</a></li>
                                                <li class="tab"><a href="#test16">Role</a></li>
                                            </ul>
                                        </div>
                        
                                        <div class="card-content">
                                            <div id="test11">
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Supply Management</h5>
                                                        <h6 class="card-subtitle">Supply Management Module</h6>
                                                    </div>
                                                    
                                                </div>
                        
                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Supplier New Code</th>
                                                                <th>Supplier Old Code</th>
                                                                <th>Supplier Name</th>
                                                                <th>Control Account</th>
                                                                <th>Vendor Group</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                               $no = 1;
                                                            ?>
                                                            <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($no); ?></td>
                                                                <td><?php echo e($supply->supplier_newcode); ?></td>
                                                                <td><?php echo e($supply->supplier_oldcode); ?></td>
                                                                <td><?php echo e($supply->supplier_name); ?></td>
                                                                <td><?php echo e($supply->supplier_control_acc); ?></td>
                                                                <td><?php echo e($supply->supplier_vendor_group); ?></td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped supply-restore" data-supplier-id="<?php echo e($supply->supplier_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped supply-delete" data-supplier-id="<?php echo e($supply->supplier_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div id="test12">          
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Spare Part</h5>
                                                        <h6 class="card-subtitle">Spare Part Module</h6>
                                                    </div>
                                                    
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable2">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Series</th>
                                                                <th>Item No</th>
                                                                <th>Die Name</th>
                                                                <th>Description</th>
                                                                <th>Supplier</th>
                                                                <th>Unit Price</th>
                                                                <th>Current Stock</th>
                                                                <th>Minimum Safety Stock</th>
                                                                <th>Department</th>
                                                                <th>Location</th>
                                                                <th>Item Status</th>
                                                                <th>Rank</th>
                                                                <th>Drawing</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                                $no = 1;
                                                            ?>
                                                            <?php $__currentLoopData = $spare_part; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($no); ?></td>
                                                                <td><?php echo e($part->sp_series); ?> </td>
                                                                <td><?php echo e($part->sp_itemno); ?> </td>
                                                                <td><?php echo e($part->sp_die_name); ?></td>
                                                                <td><?php echo e($part->sp_desc); ?></td>
                                                                <td><?php echo e($part->supplier_name); ?></td>
                                                                <td>RM<?php echo e($part->sp_unitprice); ?></td>
                                                                <td><?php echo e($part->sp_opening_stock); ?></td>
                                                                <td><?php echo e($part->sp_min_stock); ?></td>
                                                                <td><?php echo e($part->department_name); ?></td>
                                                                <td><?php echo e($part->sp_location); ?></td>
                                                                <td>
                                                                    <?php if($part->sp_status == 2): ?>
                                                                    Slow moving
                                                                    <?php elseif($part->sp_status == 1): ?>
                                                                    Active
                                                                    <?php else: ?>
                                                                    Non-active
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td><?php echo e($part->sp_rank == 1 ? 'Active' : 'Non-active'); ?></td>
                                                                <td>
                                                                    <?php if($part->sp_drawing != null): ?>
                                                                    <?php echo e($part->sp_drawing == 1 ? 'Active' : 'Non-active'); ?>

                                                                    <?php endif; ?> 
                                                                </td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped sp-restore" data-sp-id="<?php echo e($part->sp_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped sp-delete" data-sp-id="<?php echo e($part->sp_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div id="test13">          
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Stock In/Out</h5>
                                                        <h6 class="card-subtitle">Stock In/Out Module</h6>
                                                    </div>
                                                    
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable3">
                                                        <thead>
                                                            <tr>
                                                                <th class="center">#</th>
                                                                <th class="center">Type</th>
                                                                <th class="center">Series</th>
                                                                <th class="center">Die Name</th>
                                                                <th class="center">Item No</th>
                                                                <th class="center">Description</th>
                                                                <th class="center">Supplier</th>
                                                                <th class="center">Quantity</th>
                                                                <th class="center">User</th>
                                                                <th class="center">Date</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                                $no =1;
                                                            ?>
                                                            <?php $__currentLoopData = $out; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stockout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                            <tr>
                                                                <td class="center"><?php echo e($no); ?></td>
                                                                <td class="center"><?php echo e($stockout->si_type); ?></td>
                                                                <td class="center"><?php echo e($stockout->sp_series); ?></td>
                                                                <td class="center"><?php echo e($stockout->sp_die_name); ?></td>
                                                                <td class="center"><?php echo e($stockout->si_itemlotno); ?></td>
                                                                <td class="center"><?php echo e($stockout->sp_desc); ?></td>
                                                                <td class="center"><?php echo e($stockout->supplier_name); ?></td>
                                                                <td class="center"><?php echo e($stockout->si_quantity); ?></td>
                                                                <td class="center"><?php echo e($stockout->name); ?></td>
                                                                <td class="center"><?php echo e(date_format($stockout->created_at, 'd/m/Y')); ?></td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped si-restore" data-si-id="<?php echo e($stockout->si_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped si-delete" data-si-id="<?php echo e($stockout->si_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div id="test14">          
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Budgeting</h5>
                                                        <h6 class="card-subtitle">Budgeting Module</h6>
                                                    </div>
                                                    <div class="ml-auto">
                                                        
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable4">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Department</th>
                                                                <th>Month</th>
                                                                <th>Budget</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                                $no = 1;
                                                            ?>
                                                            <?php $__currentLoopData = $budgeting; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budgets): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($no); ?></td>
                                                                <td><?php echo e($budgets->department_name); ?></td>
                                                                <td><?php echo e(date_format(new DateTime($budgets->budget_month), 'm / Y')); ?></td>
                                                                <td>RM<?php echo e(number_format($budgets->budget_budget, 2)); ?> </td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped budget-restore" data-budget-id="<?php echo e($budgets->budget_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped budget-delete" data-budget-id="<?php echo e($budgets->budget_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div id="test15">          
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Department</h5>
                                                        <h6 class="card-subtitle">Department Module</h6>
                                                    </div>
                                                    <div class="ml-auto">
                                                        
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable5">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Department</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                                $no = 1;
                                                            ?>
                                                            <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                            <tr>
                                                                <td><?php echo e($no); ?></td>
                                                                <td><?php echo e($departments->department_name); ?></td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped department-restore" data-department-id="<?php echo e($departments->department_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped department-delete" data-department-id="<?php echo e($departments->department_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div id="test16">          
                                                <div class="d-flex align-items-center">
                                                    <div>
                                                        <h5 class="card-title">Role</h5>
                                                        <h6 class="card-subtitle">Role Module</h6>
                                                    </div>
                                                    <div class="ml-auto">
                                                        
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table striped m-b-20" id="editable-datatable6">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Name</th>
                                                                <th class="center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                                $no = 1;
                                                            ?>
                                                            <?php $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($no); ?></td>
                                                                <td><?php echo e($roles->ur_name); ?></td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_update');
                                                                        $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                                ->where('up_module', 'Restore')
                                                                                ->where('id', Auth::user()->id)
                                                                                ->value('is_delete');
                                                                    ?> 
                                                                    <?php if($update != 0): ?>
                                                                    <span class="label label-blue tooltipped role-restore" data-role-id="<?php echo e($roles->ur_id); ?>" data-tooltip="Restore"><i class="fas fa-sync-alt"></i></span>
                                                                    <?php endif; ?>
                                                                    <?php if($delete != 0): ?>
                                                                    <span class="label label-ready tooltipped role-delete" data-role-id="<?php echo e($roles->ur_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            <?php
                                                                $no++;
                                                            ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            
                                        </div>

                                    </div>
                                </div>  
                            </div>  
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>
    
    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <script>

    $(function() {

        $('#editable-datatable').DataTable();
        $('#editable-datatable2').DataTable();
        $('#editable-datatable3').DataTable();
        $('#editable-datatable4').DataTable();
        $('#editable-datatable5').DataTable();
        $('#editable-datatable6').DataTable();

    });

    //Supply Management
    $('.supply-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This supplier will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('supplier-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-supplier', ['supplier_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.supply-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This supplier will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('supplier-id');
            var deleteUrl = "<?php echo e(route('restore-supplier', ['supplier_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    //Spare Part
    $('.sp-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This spare part will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('sp-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-sparepart', ['sp_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.sp-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This spare part will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('sp-id');
            var deleteUrl = "<?php echo e(route('restore-sparepart', ['sp_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    //Stock In/Out
    $('.si-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This stock will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('si-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-stock', ['si_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.si-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This stock will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('si-id');
            var deleteUrl = "<?php echo e(route('restore-stock', ['si_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    //Budget
    $('.budget-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This budget will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('budget-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-budget', ['budget_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.budget-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This budget will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('budget-id');
            var deleteUrl = "<?php echo e(route('restore-budget', ['budget_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    //Department
    $('.department-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This department will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('department-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-department', ['department_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.department-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This department will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('department-id');
            var deleteUrl = "<?php echo e(route('restore-department', ['department_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    //Role
    $('.role-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This role will be permanently delete!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('role-id');
            var deleteUrl = "<?php echo e(route('permanent-delete-role', ['ur_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    $('.role-restore').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This role will be restored!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, restore it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('role-id');
            var deleteUrl = "<?php echo e(route('restore-role', ['ur_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

</body>
</html>

<?php /**PATH C:\xampp\htdocs\HIROSE\HiroseInventory2\resources\views/restore.blade.php ENDPATH**/ ?>