<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
        <title>HRS - Inventory</title>
        <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/pages/authentication.css')); ?>" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url(<?php echo e(asset('images/big/auth-bg2.jpg')); ?>) no-repeat left center;">
                <div class="container">
                    <div class="row">
                        <div class="col s12 l8 m6 demo-text">
                            <img src="<?php echo e(asset('images/hrs.png')); ?>" alt="logo" width="17%" />
                            <h1 class="font-light m-t-40"><span class="font-medium black-text">Inventory Management System</span></h1>
                            
                        </div>
                    </div>

                    <div class="auth-box auth-sidebar">
                        <div id="loginform">
                            <div class="p-l-10">
                                <h5 class="font-medium m-b-0 m-t-40">Login</h5>
                                <small>Just login to your account</small>
                            </div>
                            <!-- Form -->
                            <div class="row">
                                <form class="col s12" method="POST" action="<?php echo e(route('login')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <!-- username -->
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="username" name="username" type="text" class="validate"
                                            <?php if(Cookie::has('username')): ?> value="<?php echo e(Cookie::get('username')); ?>" <?php endif; ?>
                                            required>
                                            <label for="username">Username</label>
                                        </div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row">
                                        <div class="input-field col s12 l11">
                                            <input id="password" type="password" name="password" class="validate"
                                            <?php if(Cookie::has('password')): ?> value="<?php echo e(Cookie::get('password')); ?>" <?php endif; ?>
                                            required>
                                            <label for="password">Password</label>
                                        </div>
                                        <div class="input-field col s12 l1 bottom">
                                            <br>
                                            <i class="fas fa-eye-slash" id="toggle-password"></i>
                                        </div>
                                    </div>

                                    <!-- remember -->
                                    <div class="row m-t-5">
                                        <div class="col s7">
                                            <label>
                                                <input type="checkbox"
                                                <?php if(Cookie::has('username')): ?> value="<?php echo e(Cookie::get('username')); ?>" checked <?php endif; ?>
                                                name="rememberme" id="rememberme">
                                                <span>Remember Me?</span>
                                            </label>
                                        </div>
                                        <div class="col s5 right-align"><a href="#" class="link" id="to-recover">Forgot Password ?</a></div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row m-t-40">
                                        <div class="col s12">
                                            <button type="submit" class="btn-large w100 blue accent-4" type="submit">Login</button>
                                        </div>
                                    </div>

                                    <?php if(session('username')): ?>
                                        <script>
                                            alert('Wrong Username / Password', 'TEST');
                                        </script>
                                    <?php elseif(session('non-active')): ?>
                                        <script>
                                            alert('The user account non-active', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                </form>
                            </div>

                            
                        </div>

                        <div id="recoverform">
                            <div class="p-l-10">
                                <h5 class="font-medium m-b-0 m-t-40">Forgot Password?</h5>
                                <small>Enter your last 4 digit IC No</small>
                            </div>
                            <div class="row">
                                <form class="col s12" action="<?php echo e(route('reset-pass')); ?>" method="GET">

                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="email1" type="number" class="validate" name="ic_no" required>
                                            <label for="email1">Last 4 Digit IC No</label>
                                        </div>
                                    </div>

                                    <!-- Error message -->
                                    <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <center><ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <script>
                                                    alert("We can't find any last 4 digit IC number");
                                                </script>
                                                
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul></center>
                                    </div>
                                    <?php endif; ?>

                                    <!-- pwd -->
                                    <div class="row m-t-20">
                                        <div class="col s12">
                                            <button type="submit" class="btn-large w100 red" name="action">Submit</button>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="right-align"><a href="#" class="link" id="to-login">Back to Login </a></div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
        <script>
            $('.tooltipped').tooltip();

            $('#to-recover').on("click", function() {
                $("#loginform").slideUp();
                $("#recoverform").fadeIn();
            });

            $('#to-login').on("click", function() {
                $("#loginform").slideDown();
                $("#recoverform").fadeOut();
            });

            $(function() {
                $(".preloader").fadeOut();
            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const passwordInput = document.getElementById('password');
                const togglePasswordIcon = document.getElementById('toggle-password');

                togglePasswordIcon.addEventListener('click', function() {
                    if (passwordInput.type === 'password') {
                        passwordInput.type = 'text';
                        togglePasswordIcon.classList.remove('fa-eye-slash');
                        togglePasswordIcon.classList.add('fa-eye');
                    } else {
                        passwordInput.type = 'password';
                        togglePasswordIcon.classList.remove('fa-eye');
                        togglePasswordIcon.classList.add('fa-eye-slash');
                    }
                });
            });
        </script>
    </body>
</html>
<?php /**PATH /home/demo6861/public_html/hiroseinventory/resources/views/auth/login.blade.php ENDPATH**/ ?>