<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        <?php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($restore != 0): ?>
                        <li><a href="<?php echo e(route('restore')); ?>" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        <?php endif; ?>
                        


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Stock Out History</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    
                                        <div class="row">
                                            <div class="input-field left">
                                                <a href="#modal4" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                                
                                                
                                            </div>
                                            <?php
                                                $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                            ->where('up_module', 'Stock In/Out')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_create');
                                            ?>
                                            <?php if($create == 1): ?>
                                            <div class="input-field col s12 l8 right">
                                                
                                                <a class="waves-effect waves-light btn indigo right modal-trigger" href="<?php echo e(route('addstockout')); ?>" id="addStockOutBtn">Add Stock Out</a>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    <th class="center">#</th>
						    <th class="center">Line No</th>
                                                    <th class="center">Series</th>
                                                    <th class="center">Die Name</th>
                                                    <th class="center">Item No</th>
                                                    <th class="center">Item Lot No</th>
                                                    <th class="center">Description</th>
                                                    <th class="center">Supplier</th>
                                                    <th class="center">Unit Price</th>
                                                    <th class="center">Quantity</th>
                                                    <th class="center">Attachment</th>
                                                    <th class="center">User</th>
                                                    <th class="center">Date</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            <tbody id="stock_out">
                                                <?php
                                                    $no =1;
                                                ?>
                                                <?php $__currentLoopData = $out; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stockout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr id="role-<?php echo e($stockout->si_id); ?>">
                                                    <td class="center"><?php echo e($no); ?></td>
						    <td class="center"><?php echo e($stockout->sp_line); ?></td>
                                                    <td class="center"><?php echo e($stockout->sp_series); ?></td>
                                                    <td class="center"><?php echo e($stockout->sp_die_name); ?></td>
                                                    <td class="center"><?php echo e($stockout->sp_itemno); ?></td>
                                                    <td class="center">
                                                        
                                                            <?php echo e($stockout->si_itemlotno); ?>

                                                    </td>
                                                    <td class="center"><?php echo e($stockout->sp_desc); ?></td>
                                                    <td class="center"><?php echo e($stockout->supplier_name); ?></td>
                                                    <td class="center">RM<?php echo e($stockout->sp_unitprice); ?></td>
                                                    <td class="center"><?php echo e($stockout->si_quantity); ?></td>
                                                    <?php
                                                        $link = "https://demo1.tamarix.com.my/hrsinventory/storage/app/attachment/".$stockout->sp_id."/".$stockout->si_attachment;
                                                    ?>
                                                    <td class="center"><a href="<?php echo e($link); ?>" target="blank"><?php echo e($stockout->si_attachment); ?></a></td>
                                                    <td class="center"><?php echo e($stockout->name); ?></td>
                                                    <td class="center"><?php echo e(date_format($stockout->created_at, 'd/m/Y')); ?></td>
                                                    <td class="center">
                                                        <?php
                                                            $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Stock In/Out')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_update');
                                                            $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Stock In/Out')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_delete');
                                                        ?>
                                                        <?php if($update == 1): ?>
                                                        

                                                        <a href="<?php echo e(route('edit-stockinout',$stockout->si_id)); ?>"><span class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit" ></i></span></a>
                                                        <?php endif; ?>
                                                        <?php if($delete == 1): ?>
                                                        <span class="label label-ready tooltipped sa-delete" data-stock-id="<?php echo e($stockout->si_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <?php
                                                    $no++;
                                                ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>

                                    
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        

        <!-- Filter Modal-->
        <div id="modal4" class="modal modal-fixed-footer">
            <div class="modal-content">
            <h4 class="modalheader">Filter Stock Out</h4>
            <form method="GET" action="<?php echo e(route('stockout')); ?>" id="form">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Series</h6>
                    <input type="text" list="series" placeholder="Series" name="series" />
                    <datalist id="series">
                        <?php $__currentLoopData = $filter_series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($series); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Die Name</h6>
                    <input type="text" list="dies" placeholder="Die Name" name="die" />
                    <datalist id="dies">
                        <?php $__currentLoopData = $filter_die; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $die): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($die); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Item No</h6>
                    <input type="text" list="itemno" placeholder="Item No" name="itemno" />
                    <datalist id="itemno">
                        <?php $__currentLoopData = $filter_itemno; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($itemno); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Item Lot No</h6>
                    <input type="text" list="itemlotno" placeholder="Item Lot No" name="itemlotno" />
                    <datalist id="itemlotno">
                        <?php $__currentLoopData = $filter_itemlotno; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemlotno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($itemlotno); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Description</h6>
                    <input type="text" list="desc" placeholder="Description" name="desc" />
                    <datalist id="desc">
                        <?php $__currentLoopData = $filter_desc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $desc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($desc); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Supplier Name</h6>
                    <input type="text" list="supplier" placeholder="Supplier Name" name="supplier" />
                    <datalist id="supplier">
                        <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suppliers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($suppliers->supplier_name); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Quantity</h6>
                    <input type="text" list="quantity" placeholder="Quantity" name="quantity" />
                    <datalist id="quantity">
                        <?php $__currentLoopData = $filter_quantity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quantity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($quantity); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">User</h6>
                    <input type="text" list="user" placeholder="User" name="user" />
                    <datalist id="user">
                        <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $users): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($users->name); ?>"></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </datalist>
                    
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Date</h6>
                    <input id="date" name="date" type="date">
                </div>
            </div>
                <div class="row">
                    <div class="col s12">
                        <center>
                            <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                            <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                        </center>
                    </div>
                </div>
            </form>
        </div>
        </div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();
        $('#editable-datatable2').DataTable();

    });

    $('#add-sparepart').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
        swal({
            title: "Are you sure?",
            text: "Are you sure want to add new spare part?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
            closeOnConfirm: false
        }).then((result) => {
            if (result.value) {
                var orderId = deleteButton.data('reject-id'); // Access the addressId using the stored reference
                var deleteUrl = "";
                deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
                window.location.href = deleteUrl;
            }
        });
    });

    $('.sa-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This stock data will be deleted!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('stock-id');
            var deleteUrl = "<?php echo e(route('delete-stock', ['si_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

    <script>
    function toggleButtons() {
        var stock = document.getElementById('stock').value;
        // var addStockInBtn = document.getElementById('addStockInBtn');
        // var addStockOutBtn = document.getElementById('addStockOutBtn');
        var stockInTbody = document.getElementById('stock_in');
        var stockOutTbody = document.getElementById('stock_out');

            if (stock === 'stock_in') {
                // addStockInBtn.style.display = 'inline-block';
                // addStockOutBtn.style.display = 'none';
                stockInTbody.style.display = 'table-row-group';
                stockOutTbody.style.display = 'none';
            } else if (stock === 'stock_out') {
                // addStockInBtn.style.display = 'none';
                // addStockOutBtn.style.display = 'inline-block';
                stockInTbody.style.display = 'none';
                stockOutTbody.style.display = 'table-row-group';
            }
    }
    </script>

    <script>
        function editStock(si_id) {
            console.log('Hi');
            const nameInput = document.querySelector(`#role-${si_id} input[name="itemlotno"]`);
            const editButton = document.querySelector(`#role-${si_id} span[onclick="editStock(${si_id})"]`);
            const updateButton = document.querySelector(`#role-${si_id} button[name="button"]`);
            const deleteButton = document.querySelector(`#role-${si_id} span[data-tooltip="Delete"]`);
            const cancelButton = document.querySelector(`#role-${si_id} span[data-tooltip="Cancel"]`);

            nameInput.disabled = false;
            editButton.style.display = 'none';
            updateButton.style.display = 'inline';
            cancelButton.style.display = 'inline';
            deleteButton.style.display = 'none';
        }

        function updateStock(si_id) {

            const nameInput = document.querySelector(`#role-${si_id} input[name="itemlotno"]`);
            const editButton = document.querySelector(`#role-${si_id} span[onclick="editStock(${si_id})"]`);
            const updateButton = document.querySelector(`#role-${si_id} button[name="button"]`);
            const deleteButton = document.querySelector(`#role-${si_id} span[data-tooltip="Delete"]`);
            const cancelButton = document.querySelector(`#role-${si_id} span[data-tooltip="Cancel"]`);

            nameInput.disabled = true;
            editButton.style.display = 'inline';
            deleteButton.style.display = 'inline';
            updateButton.style.display = 'none';
            cancelButton.style.display = 'none';

        }

    </script>

</body>
</html>

<?php /**PATH /home/demo6861/public_html/hiroseinventory/resources/views/stockout.blade.php ENDPATH**/ ?>