<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        <?php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($restore != 0): ?>
                        <li><a href="<?php echo e(route('restore')); ?>" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        <?php endif; ?>
                        


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger tooltipped" data-tooltip="Profile" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                         <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Dashboard</h5>
                            </div>
                            <br>
                            <nav class="nav-extended">
                                <div class="nav-content">
                                    <ul class="tabs tabs-transparent">
                                        <li class="tab">
                                            <a href="#all">All</a>
                                        </li>

                                        <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                                <li class="tab"><a href="#<?php echo e($dpt->department_name); ?>"><?php echo e($dpt->department_name); ?></a></li>
                                            
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">

                <div id="all" class="col s12">

                    <div class="row">
                        <div class="col s12 l4">
                            <div class="card">
                                <div class="card-content">
                                    <h5 class="card-title">Spare Parts</h5>
                                    <h6 class="card-subtitle">Spare Part Categories SS</h6>
                                    <div class="m-t-30" id="SSall" style="height:280px; width:100%"></div>
                                </div>

                                <div class="card-action">
                                    <div class="row">
                                        <div class="col s4">
                                            <i class="fa fa-circle green-text"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SS_active_all); ?></h4>
                                            <span>Active</span>
                                        </div>

                                        <div class="col s4">
                                            <i class="fa fa-circle blue-text text-accent-4"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SS_nonactive_all); ?></h4>
                                            <span>Non-Active</span>
                                        </div>

                                        <div class="col s4">
                                            <i class="fa fa-circle orange-text"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SS_slow_all); ?></h4>
                                            <span>Slow Moving</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col s12 l4">
                            <div class="card">
                                <div class="card-content">
                                    <h5 class="card-title">Spare Parts</h5>
                                    <h6 class="card-subtitle">Spare Part Categories SK</h6>
                                    <div class="m-t-30" id="SKall" style="height:280px; width:100%"></div>
                                </div>

                                <div class="card-action">
                                    <div class="row">
                                        <div class="col s4">
                                            <i class="fa fa-circle green-text"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SK_active_all); ?></h4>
                                            <span>Active</span>
                                        </div>

                                        <div class="col s4">
                                            <i class="fa fa-circle blue-text text-accent-4"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SK_nonactive_all); ?></h4>
                                            <span>Non-Active</span>
                                        </div>

                                        <div class="col s4">
                                            <i class="fa fa-circle orange-text"></i>
                                            <h4 class="m-b-0 font-medium"><?php echo e($SK_slow_all); ?></h4>
                                            <span>Slow Moving</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col s12 l4">
                            <div class="card" style="height:507px; padding-top:50px;" >
                                <div class="card-content">
                                <div class="center-align">
                                    <h4 class="font-medium">Total Supplier</h4><br>
                                    <i class="material-icons display-5 light-blue-text db">insert_chart</i>
                                    <span class="display-4 db blue-grey-text font-medium text-darken-3"><?php echo e($supply_count); ?></span>
                                    <span>Total Supplier</span><br>
                                    <div class="progress m-t-30">
                                    <div class="determinate blue" style="width:100%"></div>
                                    </div><br>
                                    <a href="<?php echo e(route('supply')); ?>" class="waves-effect waves-light m-t-20 btn-large blue accent-4 m-b-20">View More Details</a>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col s12">
                            <div class="card">
                                <div class="card-content">

                                    <div class="d-flex align-items-center">
                                        <div>
                                            <h5 class="card-title">Low Stock</h5>
                                            <h6 class="card-subtitle">Restock Needed</h6>
                                        </div>
                                    </div>

                                    <div class="scrollable-container">
                                        <div class="table-responsive p-o" style="height:375px;">
                                            <table class="table m-b-20" id="editable-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Supplier</th>
                                                        <th>Series</th>
                                                        <th>Item No</th>
                                                        <th>Description</th>
                                                        <th>Category</th>
                                                        <th>Stock</th>
                                                        <th>Action Taken</th>
                                                        <th> </th>
                                                        
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $update = DB::table('users')->join('user_permission', 'up_role_id', '=', 'user_role_id')
                                                            ->where('up_module', 'Supply Management')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_update');
                                                    ?>
                                                    <?php $__currentLoopData = $low_stock_all; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $low): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr id="lowstock-<?php echo e($low->sp_id); ?>">
                                                            <td>
                                                                <h5 class="m-b-0 font-16 font-medium"><?php echo e($low->supplier_name); ?></h5>
                                                            </td>
                                                            <td><?php echo e($low->sp_series); ?></td>
                                                            <td><?php echo e($low->sp_itemno); ?></td>
                                                            <td><?php echo e($low->sp_desc); ?></td>
                                                            <td><?php echo e($low->sp_category); ?></td>
                                                            <td class="blue-grey-text text-darken-4 font-medium"><?php echo e($low->sp_opening_stock); ?></td>
                                                            <td>
                                                                <form action="<?php echo e(route('update-lowstock', $low->sp_id)); ?>" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('PUT'); ?>
                                                                    <input type="text" id="lowstock" name="sp_actiontaken" value="<?php echo e($low->sp_actiontaken); ?>" disabled>
                                                            </td>
                                                            <td class="center">
                                                                <?php
                                                                    $update = DB::table('users')->join('user_permission', 'up_role_id', '=', 'user_role_id')
                                                                        ->where('up_module', 'Supply Management')
                                                                        ->where('id', Auth::user()->id)
                                                                        ->value('is_update');
                                                                ?>
                                                                <?php if($update == 1): ?>
                                                                    <button type="submit" name="button" style="display:none;">
                                                                        <span class="label label-blue tooltipped sa-success" data-tooltip="Save">
                                                                            <i class="fas fa-check"></i>
                                                                        </span>
                                                                    </button>
                                                                    
                                                                    <span onclick="updateLowStock(<?php echo e($low->sp_id); ?>)"  class="label label-ready tooltipped" style="display: none;" data-tooltip="Cancel">
                                                                        <i class="fas fa-times"></i>
                                                                    </span>
                                                                
                                                                </form>
                                                                <span onclick="editLowStock(<?php echo e($low->sp_id); ?>)" class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit"></i></span>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <a href="<?php echo e(route('addstockin')); ?>"><i class="fas fa-angle-right"></i> Proceed to Restock</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col s12">
                            <div class="card">
                                <div class="card-content">

                                    <div class="d-flex align-items-center">
                                        <div>
                                            <h5 class="card-title">Department</h5>
                                            <h6 class="card-subtitle">Departments that have exceeded the budget</h6>
                                        </div>
                                    </div>

                                    <div class="scrollable-container">
                                        <div class="table-responsive p-o" style="height:230px;">
                                            <table class="">
                                                <thead>
                                                    <tr>
                                                        <th>Department</th>
                                                        <th>Month</th>
                                                        <th>Budget Limit</th>
                                                        <th>Current Budget</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $exceed_budget_all; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exceed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($exceed->budget_month == $exceed->month_year): ?>
                                                    <tr>
                                                        <td class="blue-grey-text  text-darken-4 font-medium"><?php echo e($exceed->department_name); ?></td>
                                                        <td><?php echo e($exceed->budget_month); ?></td>
                                                        <td>RM <?php echo e($exceed->budget_budget); ?></td>
                                                        <td>RM <?php echo e($exceed->total_budget); ?></td>
                                                    </tr>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <a href="<?php echo e(route('budgeting')); ?>"><i class="fas fa-angle-right"></i> View Budgetting List</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col s12">
                            <div class="card">
                                <div class="card-content">

                                    <div class="d-flex align-items-center">
                                        <div>
                                            <h5 class="card-title">Stock In/Out</h5>
                                            <h6 class="card-subtitle">Recent Stock In/Out</h6>
                                        </div>
                                    </div>

                                    <div class="table-responsive scrollable p-o" style="height:375px;">
                                        <table class="">
                                            <thead>
                                                <tr>
                                                    <th>Item No</th>
                                                    
                                                    <th>Type</th>
                                                    <th>Quantity</th>
                                                    <th>Description</th>
                                                    <th>Unit Price</th>
                                                    <th>User</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $stockinout_all; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <h5 class="m-b-0 font-16 font-medium"><?php echo e($stock->sp_itemno); ?></h5>
                                                    </td>
                                                    
                                                    <td><?php echo e($stock->si_type); ?></td>
                                                    <td><?php echo e($stock->si_quantity); ?></td>
                                                    <td><?php echo e($stock->sp_desc); ?></td>
                                                    <td class="blue-grey-text  text-darken-4 font-medium">RM <?php echo e($stock->sp_unitprice); ?></td>
                                                    <td><?php echo e($stock->name); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <a href="<?php echo e(route('stockinout')); ?>"><i class="fas fa-angle-right"></i> View Stock In/Out List</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
                <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
                <script>
                    var SS = '#SS' + "all";

                    var chart = c3.generate({
                        bindto: SS,
                        data: {
                            columns: [
                                ['Active', <?php echo e($ss_active_percen_all); ?>],
                                ['Non-Active', <?php echo e($ss_nonactive_percen_all); ?>],
                                ['Slow Moving', <?php echo e($ss_slow_percen_all); ?>],
                            ],

                            type: 'donut',
                            onclick: function(d, i) { console.log("onclick", d, i); },
                            onmouseover: function(d, i) { console.log("onmouseover", d, i); },
                            onmouseout: function(d, i) { console.log("onmouseout", d, i); }
                        },

                        donut: {
                            label: {
                                show: false
                            },
                            title: "SS",
                            width: 35,
                        },

                        legend: {
                            hide: true
                            //or hide: 'data1'
                            //or hide: ['data1', 'data2']
                        },

                        color: {
                            pattern: ['#4CAF50', '#2961ff', '#ff821c', '#7e74fb']
                        }
                    });

                    var SK = '#SK' + "all";

                    var chart = c3.generate({
                        bindto: SK,
                        data: {
                            columns: [
                                ['Active', <?php echo e($sk_active_percen_all); ?>],
                                ['Non-Active', <?php echo e($sk_nonactive_percen_all); ?>],
                                ['Slow Moving', <?php echo e($sk_slow_percen_all); ?>],
                            ],

                            type: 'donut',
                            onclick: function(d, i) { console.log("onclick", d, i); },
                            onmouseover: function(d, i) { console.log("onmouseover", d, i); },
                            onmouseout: function(d, i) { console.log("onmouseout", d, i); }
                        },

                        donut: {
                            label: {
                                show: false
                            },
                            title: "SK",
                            width: 35,
                        },

                        legend: {
                            hide: true
                            //or hide: 'data1'
                            //or hide: ['data1', 'data2']
                        },

                        color: {
                            pattern: ['#4CAF50', '#2961ff', '#ff821c', '#7e74fb']
                        }
                    });
                </script>

                <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php
                        $SS_nonactive = DB::table('spare_part')->where('sp_category', 'SS')->where('sp_status', 0)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $SS_active = DB::table('spare_part')->where('sp_category', 'SS')->where('sp_status', 1)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $SS_slow = DB::table('spare_part')->where('sp_category', 'SS')->where('sp_status', 2)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $ss_nonactive_percen = ($SS_nonactive / 100) * ($SS_nonactive + $SS_active + $SS_slow);
                        $ss_active_percen = ($SS_active / 100) * ($SS_nonactive + $SS_active + $SS_slow);
                        $ss_slow_percen = ($SS_slow / 100) * ($SS_nonactive + $SS_active + $SS_slow);

                        $SK_nonactive = DB::table('spare_part')->where('sp_category', 'SK')->where('sp_status', 0)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $SK_active = DB::table('spare_part')->where('sp_category', 'SK')->where('sp_status', 1)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $SK_slow = DB::table('spare_part')->where('sp_category', 'SK')->where('sp_status', 2)->where('is_deleted', 0)->where('sp_department', $dpts->department_id)->count();
                        $sk_nonactive_percen = ($SK_nonactive / 100) * ($SK_nonactive + $SK_active + $SK_slow);
                        $sk_active_percen = ($SK_active / 100) * ($SK_nonactive + $SK_active + $SK_slow);
                        $sk_slow_percen = ($SK_slow / 100) * ($SK_nonactive + $SK_active + $SK_slow);

                        $low_stock = DB::table('spare_part')->join('supplier', 'supplier.supplier_id', '=', 'spare_part.sp_supplier_id')
                                    ->whereColumn('spare_part.sp_opening_stock', '<=', 'spare_part.sp_min_stock')
                                    ->where('spare_part.is_deleted', 0)
                                    ->where('spare_part.sp_department', $dpts->department_id)
                                    ->orderBy('sp_id', 'DESC')
                                    ->get();

                        $exceed_budget = DB::table('stock_inout')->select(
                                        'department.department_name',
                                        'budget.budget_budget',
                                        'budget.budget_month',
                                        DB::raw('DATE_FORMAT(stock_inout.created_at, "%Y-%m") as month_year'),
                                        DB::raw('SUM(stock_inout.si_total) as total_budget')
                                    )
                                    ->leftjoin('spare_part', 'spare_part.sp_id', '=', 'stock_inout.si_sp_id')
                                    ->join('department', 'department.department_id', '=', 'spare_part.sp_department')
                                    ->join('budget', 'budget.budget_department', '=', 'department.department_id')
                                    ->where('spare_part.is_deleted', 0)
                                    ->where('stock_inout.is_deleted', 0)
                                    ->where('stock_inout.si_type', 'Stock In')
                                    ->where('spare_part.sp_department', $dpts->department_id)
                                    ->groupBy('spare_part.sp_department', 'department.department_name', 'budget.budget_budget', 'budget.budget_month', 'month_year')
                                    ->havingRaw('SUM(stock_inout.si_total) > budget.budget_budget')
                                    ->get();

                        $stockinout = DB::table('stock_inout')->join('spare_part', 'sp_id','=','si_sp_id')
                                    ->join('users', 'id','=','si_who')
                                    ->where('stock_inout.is_deleted', 0)
                                    ->where('spare_part.sp_department', $dpts->department_id)
                                    ->orderBy('stock_inout.created_at', 'DESC')
                                    ->limit(5)
                                    ->orderBy('si_id', 'DESC')
                                    ->get();

                    ?>

                    <div id="<?php echo e($dpts->department_name); ?>" class="col s12">

                        <div class="row">
                            <div class="col s12 l4">
                                <div class="card">
                                    <div class="card-content">
                                        <h5 class="card-title">Spare Parts</h5>
                                        <h6 class="card-subtitle">Spare Part Categories SS</h6>
                                        <div class="m-t-30" id="SS<?php echo e($dpts->department_name); ?>" style="height:280px; width:100%"></div>
                                    </div>

                                    <div class="card-action">
                                        <div class="row">
                                            <div class="col s4">
                                                <i class="fa fa-circle green-text"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SS_active); ?></h4>
                                                <span>Active</span>
                                            </div>

                                            <div class="col s4">
                                                <i class="fa fa-circle blue-text text-accent-4"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SS_nonactive); ?></h4>
                                                <span>Non-Active</span>
                                            </div>

                                            <div class="col s4">
                                                <i class="fa fa-circle orange-text"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SS_slow); ?></h4>
                                                <span>Slow Moving</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col s12 l4">
                                <div class="card">
                                    <div class="card-content">
                                        <h5 class="card-title">Spare Parts</h5>
                                        <h6 class="card-subtitle">Spare Part Categories SK</h6>
                                        <div class="m-t-30" id="SK<?php echo e($dpts->department_name); ?>" style="height:280px; width:100%"></div>
                                    </div>

                                    <div class="card-action">
                                        <div class="row">
                                            <div class="col s4">
                                                <i class="fa fa-circle green-text"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SK_active); ?></h4>
                                                <span>Active</span>
                                            </div>

                                            <div class="col s4">
                                                <i class="fa fa-circle blue-text text-accent-4"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SK_nonactive); ?></h4>
                                                <span>Non-Active</span>
                                            </div>

                                            <div class="col s4">
                                                <i class="fa fa-circle orange-text"></i>
                                                <h4 class="m-b-0 font-medium"><?php echo e($SK_slow); ?></h4>
                                                <span>Slow Moving</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col s12 l4">
                                <div class="card" style="height:507px; padding-top:50px;" >
                                    <div class="card-content">
                                    <div class="center-align">
                                        <h4 class="font-medium">Total Supplier</h4><br>
                                        <i class="material-icons display-5 light-blue-text db">insert_chart</i>
                                        <span class="display-4 db blue-grey-text font-medium text-darken-3"><?php echo e($supply_count); ?></span>
                                        <span>Total Supplier</span><br>
                                        <div class="progress m-t-30">
                                        <div class="determinate blue" style="width:100%"></div>
                                        </div><br>
                                        <a href="<?php echo e(route('supply')); ?>" class="waves-effect waves-light m-t-20 btn-large blue accent-4 m-b-20">View More Details</a>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col s12">
                                <div class="card">
                                    <div class="card-content">

                                        <div class="d-flex align-items-center">
                                            <div>
                                                <h5 class="card-title">Low Stock</h5>
                                                <h6 class="card-subtitle">Restock Needed</h6>
                                            </div>
                                        </div>

                                        <div class="scrollable-container">
                                            <div class="table-responsive p-o" style="height:375px;">
                                                <table class="table m-b-20" id="editable-datatable">
                                                    <thead>
                                                        <tr>
                                                            <th>Supplier</th>
                                                            <th>Series</th>
                                                            <th>Item No</th>
                                                            <th>Description</th>
                                                            <th>Category</th>
                                                            <th>Stock</th>
                                                            <th>Action Taken</th>
                                                            <th> </th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                            $update = DB::table('users')->join('user_permission', 'up_role_id', '=', 'user_role_id')
                                                                ->where('up_module', 'Supply Management')
                                                                ->where('id', Auth::user()->id)
                                                                ->value('is_update');
                                                        ?>
                                                        <?php $__currentLoopData = $low_stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $low): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr id="lowstock-<?php echo e($low->sp_id); ?>">
                                                                <td>
                                                                    <h5 class="m-b-0 font-16 font-medium"><?php echo e($low->supplier_name); ?></h5>
                                                                </td>
                                                                <td><?php echo e($low->sp_series); ?></td>
                                                                <td><?php echo e($low->sp_itemno); ?></td>
                                                                <td><?php echo e($low->sp_desc); ?></td>
                                                                <td><?php echo e($low->sp_category); ?></td>
                                                                <td class="blue-grey-text text-darken-4 font-medium"><?php echo e($low->sp_opening_stock); ?></td>
                                                                <td>
                                                                    <form action="<?php echo e(route('update-lowstock', $low->sp_id)); ?>" method="POST">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('PUT'); ?>
                                                                        <input type="text" id="lowstock" name="sp_actiontaken" value="<?php echo e($low->sp_actiontaken); ?>" disabled>
                                                                </td>
                                                                <td class="center">
                                                                    <?php
                                                                        $update = DB::table('users')->join('user_permission', 'up_role_id', '=', 'user_role_id')
                                                                            ->where('up_module', 'Supply Management')
                                                                            ->where('id', Auth::user()->id)
                                                                            ->value('is_update');
                                                                    ?>
                                                                    <?php if($update == 1): ?>
                                                                        <button type="submit" name="button" style="display:none;">
                                                                            <span class="label label-blue tooltipped sa-success" data-tooltip="Save">
                                                                                <i class="fas fa-check"></i>
                                                                            </span>
                                                                        </button>
                                                                        
                                                                        <span onclick="updateLowStock(<?php echo e($low->sp_id); ?>)"  class="label label-ready tooltipped" style="display: none;" data-tooltip="Cancel">
                                                                            <i class="fas fa-times"></i>
                                                                        </span>
                                                                    
                                                                    </form>
                                                                    <span onclick="editLowStock(<?php echo e($low->sp_id); ?>)" class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit"></i></span>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                            
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('addstockin')); ?>"><i class="fas fa-angle-right"></i> Proceed to Restock</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col s12">
                                <div class="card">
                                    <div class="card-content">

                                        <div class="d-flex align-items-center">
                                            <div>
                                                <h5 class="card-title">Department</h5>
                                                <h6 class="card-subtitle">Departments that have exceeded the budget</h6>
                                            </div>
                                        </div>

                                        <div class="scrollable-container">
                                            <div class="table-responsive p-o" style="height:230px;">
                                                <table class="">
                                                    <thead>
                                                        <tr>
                                                            <th>Department</th>
                                                            <th>Month</th>
                                                            <th>Budget Limit</th>
                                                            <th>Current Budget</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $exceed_budget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exceed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($exceed->budget_month == $exceed->month_year): ?>
                                                        <tr>
                                                            <td class="blue-grey-text  text-darken-4 font-medium"><?php echo e($exceed->department_name); ?></td>
                                                            <td><?php echo e($exceed->budget_month); ?></td>
                                                            <td>RM <?php echo e($exceed->budget_budget); ?></td>
                                                            <td>RM <?php echo e($exceed->total_budget); ?></td>
                                                        </tr>
                                                        <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('budgeting')); ?>"><i class="fas fa-angle-right"></i> View Budgetting List</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col s12">
                                <div class="card">
                                    <div class="card-content">

                                        <div class="d-flex align-items-center">
                                            <div>
                                                <h5 class="card-title">Stock In/Out</h5>
                                                <h6 class="card-subtitle">Recent Stock In/Out</h6>
                                            </div>
                                        </div>

                                        <div class="table-responsive scrollable p-o" style="height:375px;">
                                            <table class="">
                                                <thead>
                                                    <tr>
                                                        <th>Item No</th>
                                                        
                                                        <th>Type</th>
                                                        <th>Quantity</th>
                                                        <th>Description</th>
                                                        <th>Unit Price</th>
                                                        <th>User</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $stockinout; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <h5 class="m-b-0 font-16 font-medium"><?php echo e($stock->sp_itemno); ?></h5>
                                                        </td>
                                                        
                                                        <td><?php echo e($stock->si_type); ?></td>
                                                        <td><?php echo e($stock->si_quantity); ?></td>
                                                        <td><?php echo e($stock->sp_desc); ?></td>
                                                        <td class="blue-grey-text  text-darken-4 font-medium">RM <?php echo e($stock->sp_unitprice); ?></td>
                                                        <td><?php echo e($stock->name); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <a href="<?php echo e(route('stockinout')); ?>"><i class="fas fa-angle-right"></i> View Stock In/Out List</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
                    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
                    <script>
                        var SS = '#SS' + "<?php echo e($dpts->department_name); ?>";

                        var chart = c3.generate({
                            bindto: SS,
                            data: {
                                columns: [
                                    ['Active', <?php echo e($ss_active_percen); ?>],
                                    ['Non-Active', <?php echo e($ss_nonactive_percen); ?>],
                                    ['Slow Moving', <?php echo e($ss_slow_percen); ?>],
                                ],

                                type: 'donut',
                                onclick: function(d, i) { console.log("onclick", d, i); },
                                onmouseover: function(d, i) { console.log("onmouseover", d, i); },
                                onmouseout: function(d, i) { console.log("onmouseout", d, i); }
                            },

                            donut: {
                                label: {
                                    show: false
                                },
                                title: "SS",
                                width: 35,
                            },

                            legend: {
                                hide: true
                                //or hide: 'data1'
                                //or hide: ['data1', 'data2']
                            },

                            color: {
                                pattern: ['#4CAF50', '#2961ff', '#ff821c', '#7e74fb']
                            }
                        });

                        var SK = '#SK' + "<?php echo e($dpts->department_name); ?>";

                        var chart = c3.generate({
                            bindto: SK,
                            data: {
                                columns: [
                                    ['Active', <?php echo e($sk_active_percen); ?>],
                                    ['Non-Active', <?php echo e($sk_nonactive_percen); ?>],
                                    ['Slow Moving', <?php echo e($sk_slow_percen); ?>],
                                ],

                                type: 'donut',
                                onclick: function(d, i) { console.log("onclick", d, i); },
                                onmouseover: function(d, i) { console.log("onmouseover", d, i); },
                                onmouseout: function(d, i) { console.log("onmouseout", d, i); }
                            },

                            donut: {
                                label: {
                                    show: false
                                },
                                title: "SK",
                                width: 35,
                            },

                            legend: {
                                hide: true
                                //or hide: 'data1'
                                //or hide: ['data1', 'data2']
                            },

                            color: {
                                pattern: ['#4CAF50', '#2961ff', '#ff821c', '#7e74fb']
                            }
                        });
                    </script>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>

    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dpts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <script>
        $(function() {
            $('#editable-datatable').Datatable();
        });

        function editLowStock(sp_id) {
        const actionInput = document.querySelector(`#lowstock-${sp_id} input[name="sp_actiontaken"]`);
        const editButton = document.querySelector(`#lowstock-${sp_id} span[onClick="editLowStock(${sp_id})"]`);
        const updateButton = document.querySelector(`#lowstock-${sp_id} button[name="button"]`);
        const cancelButton = document.querySelector(`#lowstock-${sp_id} span[data-tooltip="Cancel"]`);

        actionInput.disabled = false;
        editButton.style.display = 'none';
        updateButton.style.display = 'inline';
        cancelButton.style.display = 'inline';
    }

    function updateLowStock(sp_id) {
        const actionInput = document.querySelector(`#lowstock-${sp_id} input[name="sp_actiontaken"]`);
        const editButton = document.querySelector(`#lowstock-${sp_id} span[onClick="editLowStock(${sp_id})"]`);
        const updateButton = document.querySelector(`#lowstock-${sp_id} button[name="button"]`);
        const cancelButton = document.querySelector(`#lowstock-${sp_id} span[data-tooltip="Cancel"]`);

        actionInput.disabled = true;
        editButton.style.display = 'inline';
        updateButton.style.display = 'none';
        cancelButton.style.display = 'none';
    }

    </script>

</body>
</html>

<?php /**PATH /home/demo6861/public_html/hiroseinventory/resources/views/dashboard.blade.php ENDPATH**/ ?>