<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        <?php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($restore != 0): ?>
                        <li><a href="<?php echo e(route('restore')); ?>" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        <?php endif; ?>
                        


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                         <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Add Stock Out</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">

                                    <!-- Date and User -->
                                    <div class="row">
                                        <div class="input-field col s12 l4 ">
                                            <h6 class="labelform">Date</h6>
                                            <input type="text" name="date" value="<?php echo e($now); ?>" readonly>
                                        </div>
                                        <div class="input-field col s12 l2 ">
                                        </div>
                                        <div class="input-field col s12 l6 ">
                                            <h6 class="labelform">User</h6>
                                           <input type="text" name="user" value="<?php echo e(Auth::user()->name); ?>" readonly>
                                        </div>
                                    </div><br>
                                    

                                    <?php if(session('error')): ?>
                                        <script>
                                            alert('The requested quantity exceeds the available stock.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('error3')): ?>
                                        <script>
                                            alert('Sorry, only JPG, JPEG, PNG, PDF & TIF files are allowed.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('error2')): ?>
                                        <script>
                                            alert('Sorry, the maximum allowable file size is limited to 200 MB.', 'TEST');
                                        </script>
                                    <?php endif; ?>


                                    <!-- Spare Part Data -->
                                    <div class="row">
                                        <div style="border: 2px solid black; padding: 40px;" class="col s12">
                                            
                                            <div class="row">
                                                <div class="input-field col s12 l2 ">
                                                </div>
                                                <div class="input-field col s12 l3 ">
                                                    <h6 class="labelform">Spare Part Category</h6>
                                                    <select name="stock" id="categoryFilter">
                                                    <option value="">All Categories</option>
                                                    <option value="SK">SK</option>
                                                    <option value="SS">SS</option>
                                                    </select>
                                                </div>
                                                <div class="input-field col s12 l2 ">
                                                </div>
                                                <div class="input-field col s12 l3 ">
                                                    <h6 class="labelform">Supplier</h6>
                                                    <select id="supplierFilter">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suppliers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($suppliers->supplier_name); ?>"><?php echo e($suppliers->supplier_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="input-field col s12 l2 ">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <table class="table striped m-b-20" id="editable-datatable">
                                                    <thead>
                                                        <tr>
                                                            <th class="center">Series</th>
                                                            <th class="center">Die Name</th>
                                                            <th class="center">Item No</th>
                                                            <th class="center">Description</th>
                                                            <th class="center">Category</th>
                                                            <th class="center">Supplier</th>
                                                            <th class="center">Current Stock</th>
                                                            <th class="center">Unit Price</th>
                                                            <th class="center">Item Status</th>
                                                            <th class="center">Item Lot No</th>
                                                            <th style="display: none;" class="center">Attachment</th>
                                                            <th style="display: none;" class="center">ID</th>
                                                            <th class="center">Action</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody id="stock_in">
                                                        <?php $__currentLoopData = $part; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td class="center"><?php echo e($parts->sp_series); ?></td>
                                                            <td class="center"><?php echo e($parts->sp_die_name); ?></td>
                                                            <td class="center"><?php echo e($parts->sp_itemno); ?></td>
                                                            <td class="center"><?php echo e($parts->sp_desc); ?></td>
                                                            <td class="center" class="data-row" data-row="<?php echo e($parts->sp_category); ?>"><?php echo e($parts->sp_category); ?></td>
                                                            <td class="center" class="data-row" data-row="<?php echo e($parts->supplier_name); ?>"><?php echo e($parts->supplier_name); ?></td>
                                                            <td class="center"><?php echo e($parts->sp_opening_stock); ?></td>
                                                            <td class="center">RM<?php echo e($parts->sp_unitprice); ?></td>
                                                            <?php if($parts->sp_status == 1): ?>
                                                            <td class="center">Active</td>
                                                            <?php elseif($parts->sp_status == 2): ?>
                                                            <td class="center">Slow moving</td>
                                                            <?php else: ?>
                                                            <td class="center">Non-Active</td>
                                                            <?php endif; ?>

                                                            <?php if($parts->stockInOut->isNotEmpty()): ?>
                                                                <?php
                                                                    $stockIn = $parts->stockInOut->first();
                                                                ?>
                                                                <td class="center"><?php echo e($stockIn->si_itemlotno ?? '-'); ?></td>
                                                                <td style="display: none;" class="center"><?php echo e($stockIn->si_attachment ?? ''); ?></td>
                                                            <?php else: ?>
                                                                <td class="center">-</td>
                                                                <td style="display: none;" class="center"></td>
                                                            <?php endif; ?>

                                                            
                                                            <td style="display: none;" class="center"><?php echo e($parts->sp_id); ?></td>
                                                            <td class="center">
                                                                <label>
                                                                    <input type="checkbox" name="rememberme" id="rememberme" data-id="<?php echo e($parts->sp_id); ?>">
                                                                    <span></span>
                                                                </label>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    
                                     

                                    <!-- List of Item -->
                                    <br><br>
                                    <div class="row">
                                        <div class="input-field col s12" id="selected-data-form">
                                            <h6><u>List of Item</u></h6>
                                            <form id="form" method="POST" action="<?php echo e(route('updatestockout')); ?>" enctype="multipart/form-data">
                                                <?php echo method_field('PUT'); ?>
                                                <?php echo csrf_field(); ?>
                                                <table class="table striped m-b-20" id="selected-data-table">
                                                    <thead>
                                                        <tr>
                                                            <th class="center">#</th>
                                                            <th class="center">Series</th>
                                                            <th class="center">Die Name</th>
                                                            <th class="center">Item No</th>
                                                            <th class="center">Description</th>
                                                            <th class="center">Supplier</th>
                                                            <th class="center">Current Stock</th>
                                                            <th class="center">Unit Price (RM)</th>
                                                            <th class="center">Item Status</th>
                                                            <th style="display: none;" class="center">ID</th>
                                                            <th style="display: none;" class="center">Category</th>
                                                            <th class="center">Stock Out QTY</th>
                                                            <th class="center">Line</th>
                                                            <th class="center">Cause/Reason</th>
                                                            <th class="center">Item Lot No</th>
                                                            <th class="center">Attachment</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <!-- Selected data will be added dynamically here -->
                                                    </tbody>
                                                </table>

                                                <br>
                                                <button id="add-stockin" class="waves-effect waves-light btn indigo right">Submit</button><br><br>
                                            </form>
                                        </div>
                                    </div>

                                    
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        

        <br>
        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            // Initialize an array to store selected data
            var selectedData = [];

            $('#add-stockin').click(function() {
                if (selectedData.length === 0) {
                    event.preventDefault(); // Prevent form submission
                    alert('Please select at least one item.'); // Display alert
                }else{
                    event.preventDefault(); // Prevent form submission
                    // Check if all required inputs are filled
                    var isFormValid = true;
                    $('#form input[required]').each(function() {
                        if ($(this).val() === '') {
                        isFormValid = false;
                        return false; // Exit the loop if an empty required input is found
                        }
                    });

                    if(isFormValid){
                        var addButton = $(this);
                        swal({
                            title: "Are you sure?",
                            text: "Are you sure want to submit?",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "Yes",
                            closeOnConfirm: false
                            }).then((result) => {
                            if (result.value) {
                                addButton.closest("form").submit();
                            }
                            });
                    }

                }
            });

            // Add event listener to checkboxes
            $('input[type="checkbox"]').on('change', function() {
                var row = $(this).closest('tr');
                var isChecked = $(this).is(':checked');
                // var id = row.find('.center:eq(11)').text();
                var id = $(this).data('id');  // Get the data-id attribute


                if (isChecked) {
                    // Get the row data
                    var series = row.find('.center:eq(0)').text();

                    var dieName = row.find('.center:eq(1)').text();
                    var itemNo = row.find('.center:eq(2)').text();
                    var description = row.find('.center:eq(3)').text();
                    var category = row.find('.center:eq(4)').text();
                    var supplier = row.find('.center:eq(5)').text();
                    var openingQty = row.find('.center:eq(6)').text();
                    var unitPriceText = row.find('.center:eq(7)').text();
                    var unitPrice = parseFloat(unitPriceText.replace(/[^\d.]/g, ''));
                    var itemStatus = row.find('.center:eq(8)').text();
                    var itemLotNo = row.find('.center:eq(9)').text();
                    var attachmentName = row.find('.center:eq(10)').text();

                    // Add data to selectedData array
                    selectedData.push({
                        series: series,
                        dieName: dieName,
                        itemNo: itemNo,
                        description: description,
                        supplier: supplier,
                        openingQty: openingQty,
                        unitPrice: unitPrice,
                        itemStatus: itemStatus,
                        id: id,
                        category: category,
                        itemLotNo: itemLotNo,
                        attachmentName: attachmentName

                    });
                } else {
                    // Remove data from selectedData array
                    var indexToRemove = selectedData.findIndex(function(data) {
                        return data.id === id;
                    });
                    if (indexToRemove !== -1) {
                        selectedData.splice(indexToRemove, 1);
                    }
                }

                // Populate the table with selected data
                populateTable(selectedData);
            });

            // Function to populate the table with selected data
            function populateTable(dataArray) {
                var tableBody = $('#selected-data-table tbody');
                tableBody.empty();

                dataArray.forEach(function(data, index) {
                    var newRow = '<tr>' +
                        '<td class="center">' + (index + 1) + '</td>' +
                        '<td class="center">' + data.series + '</td>' +
                        '<td class="center">' + data.dieName + '</td>' +
                        '<td class="center">' + data.itemNo + '</td>' +
                        '<td class="center">' + data.description + '</td>' +
                        '<td class="center">' + data.supplier + '</td>' +
                        '<td class="center">' + data.openingQty + '</td>' +
                        '<td class="center">' + data.unitPrice.toFixed(2) + '</td>' +
                        '<td class="center">' + data.itemStatus + '</td>' +
                        '<td class="center" style="display: none;"> <input class="center" type="text" name="id[]" value="' + data.id + '"/></td>' +
                        '<td class="center"><input type="text" name="stockOutQty[]" required></td>' +
                        '<td class="center"><input type="text" name="line[]" required></td>' +
                        '<td class="center"><input type="text" name="reason[]" required></td>' +
                        '<td class="center">' + data.itemLotNo + '</td>';
                        if (data.attachmentName) {
                            var route = "<?php echo e(route('download-attachment', ['sp_id' => ':spId', 'file' => ':attachmentName'])); ?>"
                                .replace(':attachmentName', data.attachmentName)
                                .replace(':spId', data.id);
                            newRow += '<td class="center"><a href="'+route+'">' + data.attachmentName + '</a></td>';
                        } else {
                            newRow += '<td class="center">No Attachment</td>';
                        }


                        newRow += '</tr>';
                    tableBody.append(newRow);
                });
            }


        });
    </script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();
    });

    </script>

<script>
    // Get references to filter elements
    const categoryFilter = document.getElementById('categoryFilter');
    const supplierFilter = document.getElementById('supplierFilter');
    const tableRows = document.querySelectorAll('#editable-datatable tbody tr');

    // Attach event listeners for changes in filters
    categoryFilter.addEventListener('change', filterTable);
    supplierFilter.addEventListener('change', filterTable);

    function filterTable() {
        const selectedCategory = categoryFilter.value;
        const selectedSupplier = supplierFilter.value;

        tableRows.forEach(row => {
            const cells = row.getElementsByTagName('td');
            const categoryCell = cells[4]; // Assuming the category cell is the first one
            const supplierCell = cells[5]; // Assuming the supplier cell is the sixth one

            const categoryValue = categoryCell.getAttribute('data-row');
            const supplierValue = supplierCell.getAttribute('data-row');

            const showRow =
                (selectedCategory === '' || categoryValue === selectedCategory) &&
                (selectedSupplier === '' || supplierValue === selectedSupplier);

            row.style.display = showRow ? 'table-row' : 'none';
        });
    }

    // Initialize the filter on page load
    filterTable();
</script>


</body>
</html>

<?php /**PATH /home/demo6861/public_html/hiroseinventory/resources/views/addstockout.blade.php ENDPATH**/ ?>