<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/hrs.ico')); ?>">
    <title>HRS - Inventory</title>
    <link href="<?php echo e(asset('extra-libs/c3/c3.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/pages/data-table.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('css/select2.css')); ?>" rel="stylesheet">

    <?php echo csrf_field(); ?>

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media  screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="<?php echo e(route('dashboard')); ?>" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="<?php echo e(asset('images/hrs.png')); ?>" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        <?php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($restore != 0): ?>
                        <li><a href="<?php echo e(route('restore')); ?>" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        <?php endif; ?>
                        

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            <?php if($new_notification != 0): ?>
                                <span class="notification-badge"><?php echo e($new_notification); ?></span>
                            <?php endif; ?>
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        <?php $__currentLoopData = $notification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('click-notification', $notifications->notification_id)); ?>">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        <?php echo e($notifications->notification_title); ?>

                                                        <?php if($notifications->notification_is_read == 0): ?>
                                                            <span class="label label-success m-r-10">New</span>
                                                        <?php endif; ?>
                                                    </h5>
                                                    <span class="mail-desc"><?php echo e($notifications->notification_subtitle); ?></span> <span class="time"><?php echo e(date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')); ?></span>
                                                </span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="<?php echo e(route('notification')); ?>"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="<?php echo e(asset('images/users/2.jpg')); ?>" alt="user"></div>
                                        <div class="u-text">
                                            <h4><?php echo e(Auth::user()->name); ?></h4>
                                            <p><?php echo e(Auth::user()->email); ?></p>
                                            
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('profile')); ?>"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="<?php echo e(route('reset')); ?>"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="<?php echo e(route('logout')); ?>"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> 
                    <ul class="collapsible">
                        
                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('supply')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($inventory != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('spare-part')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                         <?php if($permission != 0): ?>
                                            
                                            <li><a href="<?php echo e(route('stockinout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="<?php echo e(route('stockout')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($budget != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('budgeting')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('department')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        ?>
                        <?php if($system != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('usercontrol')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('modulesetup')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        <?php endif; ?>

                                        <?php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        ?>
                                        <?php if($permission != 0): ?>
                                            <li><a href="<?php echo e(route('itemstatus')); ?>"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        <?php endif; ?>
                                        
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        ?>
                        <?php if($permission != 0): ?>
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="<?php echo e(route('audit')); ?>"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </aside>

        
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Spare Part</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    <?php if(session('excel')): ?>
                                        <script>
                                            alert('Please make a selection of the dataset for data generation within Excel.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    
                                    <?php if(session('error3')): ?>
                                        <script>
                                            alert('Sorry, only JPG, JPEG, PNG, PDF & TIF files are allowed.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('error4')): ?>
                                        <script>
                                            alert('Sorry, the maximum allowable file size is limited to 200 MB.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('month')): ?>
                                        <script>
                                            alert('Budget Month does not exist.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('error_solo1')): ?>
                                        <script>
                                            alert('Item number with supplier name already exists.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('error_solo2')): ?>
                                        <script>
                                            alert('Item number with supplier name already exists in restore module.', 'TEST');
                                        </script>
                                    <?php endif; ?>
                                    <?php if(session('errors')): ?>
                                        <div class="alert alert-danger" style="background-color: #FF5050; color:white; border-radius:5px;">
                                            <ul>
                                                <?php $__currentLoopData = session('errors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>

                                    

                                    <div class="table-responsive">
                                        <?php
                                            $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                            ->where('up_module', 'Spare Part')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_create');
                                        ?>

                                        <div class="dropdown2">
                                            <a href="#modal4" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                        </div>

                                        <?php if($create == 1): ?>
                                        
                                        <div class="dropdown2 right">
                                            <button class="waves-effect waves-light btn indigo right" onclick="toggleDropdown()">Add Spare Part</button>
                                            <div id="dropdown-content">
                                                <a href="#modal1" class="modal-trigger" onclick="selectOption('individual')">Individual</a>
                                                <a href="#modal2" class="modal-trigger" onclick="selectOption('bulk')">Bulk</a>
                                                <a href="<?php echo e(route('download-template-sparepart')); ?>" onclick="selectOption('template')">Download Template</a>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <br>
                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    
                                                    <th>#</th>
                                                    <th>Series</th>
                                                    <th>Item No</th>
                                                    <th>Line No.</th>
                                                    <th>Die Name</th>
                                                    <th>Description</th>
                                                    <th>Supplier</th>
                                                    <th>Unit Price</th>
                                                    <th class="center">Current Stock</th>
                                                    <th class="center">Minimum Safety Stock</th>
                                                    <th>Department</th>
                                                    <th>Location</th>
                                                    <th>Item Status</th>
                                                    <th class="center">Rank</th>
                                                    <th class="center">Drawing</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php
                                                    $no = 1;
                                                ?>
                                                <?php $__currentLoopData = $spare_part; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr id="item-<?php echo e($part->sp_id); ?>">
                                                    
                                                    <td><?php echo e($no); ?></td>
                                                    <td><?php echo e($part->sp_series); ?> </td>
                                                    <td><?php echo e($part->sp_itemno); ?> </td>
                                                    <td><?php echo e($part->sp_line); ?></td>
                                                    <td><?php echo e($part->sp_die_name); ?></td>
                                                    <td><?php echo e($part->sp_desc); ?></td>
                                                    <td><?php echo e($part->supplier_name); ?></td>
                                                    <td>RM<?php echo e($part->sp_unitprice); ?></td>
                                                    <td class="center"><?php echo e($part->sp_opening_stock); ?></td>
                                                    <td class="center"><?php echo e($part->sp_min_stock); ?></td>
                                                    <td><?php echo e($part->department_name); ?></td>
                                                    <td><?php echo e($part->sp_location); ?></td>
                                                    <td>
                                                        <?php if($part->sp_status == 2): ?>
                                                        Slow moving
                                                        <?php elseif($part->sp_status == 1): ?>
                                                        Active
                                                        <?php else: ?>
                                                        Non-active
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="center"><?php echo e($part->sp_rank); ?></td>
                                                    <?php
                                                        $link = "https://demo1.tamarix.com.my/hrsinventory/storage/app/spare_part/".$part->sp_id."/".$part->sp_drawing;
                                                    ?>
                                                    <td class="center"><a href="<?php echo e($link); ?>" target="blank"><?php echo e($part->sp_drawing); ?></a></td>
                                                    <td class="center">
                                                        <?php
                                                            $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Spare Part')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_update');
                                                            $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Spare Part')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_delete');
                                                        ?>
                                                        <?php if($update == 1): ?>
                                                        <a href="<?php echo e(route('edit-sparepart', $part->sp_id)); ?>" ><span class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit" ></i></span></a>
                                                        <?php endif; ?>
                                                        <?php if($delete == 1): ?>
                                                        <span class="label label-ready tooltipped sa-delete" data-sparepart-id="<?php echo e($part->sp_id); ?>" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                        <?php endif; ?>
                                                        
                                                    </td>
                                                </tr>
                                                <?php
                                                    $no++;
                                                ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <br>
                                    
                                    <a class="waves-effect waves-light btn indigo right modal-trigger" href="#modal3">Download Report</a><br><br>
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        

<!-- Modal Add Supplier -->
<div id="modal1" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Spare Part</h4>
	<form id="form" method="POST" action="<?php echo e(route('add-sparepart')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
		<div class="row">
            <div class="input-field col s12">
                <h6 class="labelform">Supplier Name*</h6>
                <select id="name" name="name" required>
                <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suppliers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($suppliers->supplier_id); ?>"><?php echo e($suppliers->supplier_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Spare Part Category*</h6>
                <select id="category" name="category" onchange="toggleButtons()" required>
                    <option value="SS" selected>SS</option>
                    <option value="SK">SK</option>
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Series</h6>
                <input id="series" name="series" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Department</h6>
                <?php
                    $department_name = DB::table('department')->where('department_id', Auth::user()->user_department_id)->value('department_name');
                ?>
                <input id="department" name="department" value="<?php echo e($department_name); ?>" disabled>
                
            </div>
        </div>
		<div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item No*</h6>
                <input id="itemno" name="itemno" type="text" required>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Lot No</h6>
                <input id="itemlotno" name="itemlotno" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Line</h6>
                <input id="line" name="line" type="text" placeholder="eg: HSI-XXX">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Location</h6>
                <input id="location" name="location" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Unit Price</h6>
                <input id="unit" name="unit" type="number">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Stock</h6>
                <input id="stock" name="stock" type="number">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Amount (RM)</h6>
                <input id="amount" name="amount" type="number" readonly placeholder="RM">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Minimum Safety Stock</h6>
                <input id="min" name="min" type="number">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Description</h6>
                <input id="desc" name="desc" type="text">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Die Name</h6>
                <input id="die" name="die" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Rank</h6>
                <select id="rank" name="rank">
                <option value="A">A</option>
                <option value="B">B</option>
                <option value="C">C</option>
                <option value="D">D</option>
                <option value="E">E</option>
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Status</h6>
                <select id="status" name="status">
                <option value="1">Active</option>
                <option value="0">Non-active</option>
                <option value="2">Slow moving</option>
                </select>
            </div>
        </div>
        <div class="row" id="drawing" style="display: none;">
            <div class="input-field col s12">
                <h6 class="labelform">Drawing</h6>
                <input id="drawing" name="drawing" type="file">
                
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <a href="#" id="modalbutton"><button  id="add-sparepart" class="waves-effect waves-light btn indigo right">Add</button></a>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Modal Add Spare Part Bulk -->
<div id="modal2" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Spare Part</h4>
	<form method="POST" action="<?php echo e(route('add-sparepart-bulk')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
		<div class="row">
            
            <div class="file-field col s12">
                <br><div class="btn blue darken-1">
                    <span>File</span>
                    <input type="file" name="file" required>
                </div>
                <div class="file-path-wrapper">
                    <input class="file-path validate" type="text">
                </div>
            </div>
        </div><br>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="add-supplier" class="waves-effect waves-light btn indigo right modal-trigger">Add</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Modal Download Spare Part Report -->
<div id="modal3" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Download Spare Part Report</h4>
	<form method="POST" action="<?php echo e(route('multi-sparepart-excel')); ?>" enctype="multipart/form-data" id="download-form">
    <?php echo csrf_field(); ?>
		<div class="row">
            <div class="input-field col s12 l6">
                <h6 class="labelform">Department</h6>
                <select id="department" name="department[]" required multiple>
                <option value="" disabled>Choose your department</option>
                <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($departments->department_id); ?>"><?php echo e($departments->department_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Type</h6>
                <select id="type" name="type" required>
                <option value="excel">Excel</option>
                <option value="pdf">PDF</option>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Month</h6>
                <input id="month" name="month" type="month" required>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="download" class="waves-effect waves-light btn indigo right modal-trigger">Download</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Filter Modal-->
<div id="modal4" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Filter Supplier</h4>
	<form method="GET" action="<?php echo e(route('spare-part')); ?>" id="form">
    <?php echo csrf_field(); ?>
        <div class="row">
            <div class="input-field col s12">
                <h6 class="labelform">Supplier Name</h6>
                <input type="text" list="supplier" placeholder="Supplier Name" name="supplier" />
                <datalist id="supplier">
                    <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suppliers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($suppliers->supplier_name); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Spare Part Category</h6>
                <input type="text" list="categories" placeholder="Category" name="category" />
                <datalist id="categories">
                    <option value="SS"></option>
                    <option value="SK"></option>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Series</h6>
                <input type="text" list="serie" placeholder="Series" name="series" />
                <datalist id="serie">
                <?php $__currentLoopData = $filter_series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $series): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($series); ?>"></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Department</h6>
                <input type="text" list="departments" placeholder="Department" name="department" />
                <datalist id="departments">
                    <?php $__currentLoopData = $department; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($departments->department_name); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item No</h6>
                <input type="text" list="filteritemno" placeholder="Item No" name="itemno" />
                <datalist id="filteritemno">
                    <?php $__currentLoopData = $filter_itemno; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($itemno); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Line</h6>
                <input type="text" list="lines" placeholder="Line" name="line" />
                <datalist id="lines">
                <?php $__currentLoopData = $filter_line; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($line); ?>"></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Location</h6>
                <input type="text" list="locationss" placeholder="Location" name="location" />
                <datalist id="locationss">
                    <?php $__currentLoopData = $filter_location; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($location); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Unit Price</h6>
                <input type="text" list="unitss" placeholder="Price" name="unit" />
                <datalist id="unitss">
                    <?php $__currentLoopData = $filter_unit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($unit); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Stock</h6>
                <input type="text" list="stockss" placeholder="Stock" name="stock" />
                <datalist id="stockss">
                    <?php $__currentLoopData = $filter_stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($stock); ?>"></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Minimum Safety Stock</h6>
                <input type="text" list="minss" placeholder="Min Stock" name="min" />
                <datalist id="minss">
                    <?php $__currentLoopData = $filter_min; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $min): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($min); ?>"><?php echo e($min); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Description</h6>
                <input type="text" list="descss" placeholder="Description" name="desc" />
                <datalist id="descss">
                    <?php $__currentLoopData = $filter_desc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $desc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($desc); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Die Name</h6>
                <input type="text" list="dienames" placeholder="Die Name" name="die" />
                <datalist id="dienames">
                    <?php $__currentLoopData = $filter_die; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $die): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($die); ?>"></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </datalist>
                
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Rank</h6>
                <input type="text" list="rankss" placeholder="Rank" name="rank" />
                <datalist id="rankss">
                    <option value="A"></option>
                    <option value="B"></option>
                    <option value="C"></option>
                    <option value="D"></option>
                    <option value="E"></option>
                </datalist>
                
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Status</h6>
                <input type="text" list="statusss" placeholder="Status" name="status" />
                <datalist id="statusss">
                    <option value="1">Active</option>
                    <option value="0">Non-active</option>
                    <option value="2">Slow moving</option>
                </datalist>
                
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                    <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="<?php echo e(asset('libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.init.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.horizontal.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app-style-switcher.js')); ?>"></script>

    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/c3/c3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('extra-libs/DataTables/jquery.dataTables.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')); ?>"></script>
    
    <script src="<?php echo e(asset('libs/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/select2/select2.full.min.js')); ?>"></script>
    

    

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();

    });

    // Sweet Alert for Add SparePart
    $(document).ready(function() {
        $('#add-sparepart').click(function() {
            event.preventDefault();

            var isFormValid = true;
            $('#form input[required]').each(function() {
                if ($(this).val() === '') {
                isFormValid = false;
                return false;
                }
            });

            if(isFormValid){
                var addButton = $(this);
                swal({
                    title: "Are you sure?",
                    text: "Are you sure want to add new spare part?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    closeOnConfirm: false
                    }).then((result) => {
                    if (result.value) {
                        addButton.closest("form").submit();
                    }
                    });
            } else {
                alert("Please fill all required fields before adding a new spare part.");
            }

        });
    });

    // Sweet Alert for Delete Spare Part
    $('.sa-delete').click(function() {
    var deleteButton = $(this);
      swal({
          title: "Are you sure?",
          text: "This spare part will be deleted!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('sparepart-id');
            var deleteUrl = "<?php echo e(route('delete-sparepart', ['sp_id' => 'TEMP_ID'])); ?>";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

    <script>
        //Hide and Show Drawing Field
        function toggleButtons() {
            var category = document.getElementById('category').value;
            var drawing = document.getElementById('drawing');

            if (category === 'SS') {
                drawing.style.display = 'none';
            } else if (category === 'SK') {
                drawing.style.display = 'inline-block';
            }
        }

        function toggleButtons2() {
            var category2 = document.getElementById('category2').value;
            var drawing2 = document.getElementById('drawing2');

            if (category2 === 'SS') {
                console.log('none');
                drawing2.style.display = 'none';
            } else if (category2 === 'SK') {
                console.log('ada');
                drawing2.style.display = 'inline-block';
            }
        }
    </script>

    <script>
        // Auto Calculate for Opening Amount
        $(document).ready(function () {
            const unitInput = $("#unit");
            const stockInput = $("#stock");
            const amountInput = $("#amount");

            function updateOpeningAmount() {
                const unitPrice = parseFloat(unitInput.val());
                const openingStock = parseFloat(stockInput.val());

                const openingAmount = unitPrice * openingStock;

                amountInput.val(openingAmount.toFixed(2));
            }

            unitInput.on("input", updateOpeningAmount);
            stockInput.on("input", updateOpeningAmount);
        });
    </script>

    <script>
        // Dropdown for add spare part individually or bulky
        function toggleDropdown() {
            var dropdownContent = document.getElementById("dropdown-content");
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        }

        function toggleDropdown2() {
            var dropdownContent = document.getElementById("dropdown-content-download");
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        }

        function selectOption(option) {
            document.getElementById("dropdown-btn").innerHTML = option;
            document.getElementById("dropdown-content").style.display = "none";
        }
    </script>

    <script>
        // Get spare part id from checkbox
        document.addEventListener('DOMContentLoaded', function() {
            var excelOption = document.getElementById('excel-option');

            excelOption.addEventListener('click', function(event) {
                event.preventDefault();

                var checkboxes = document.getElementsByName('check');
                var selectedValues = [];

                for (var i = 0; i < checkboxes.length; i++) {
                    if (checkboxes[i].checked) {
                        selectedValues.push(checkboxes[i].value);
                    }
                }

                var url = '<?php echo e(route("multi-sparepart-excel")); ?>?selectedValues=' + selectedValues.join(',');

                window.location.href = url;
            });
        });

        document.addEventListener("DOMContentLoaded", function () {
            const selectAllCheckbox = document.getElementById("check-all");
            const checkboxes = document.querySelectorAll(".check");

            selectAllCheckbox.addEventListener("click", function () {
                checkboxes.forEach(function (checkbox) {
                    checkbox.checked = selectAllCheckbox.checked;
                });
            });
        });
    </script>

    

</body>
</html>

<?php /**PATH C:\xampp\htdocs\HIROSE\HiroseInventory2\resources\views/spare-part.blade.php ENDPATH**/ ?>