<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SupplyController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\BudgetController;
use App\Http\Controllers\SystemManagementController;
use App\Http\Controllers\AuditController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Authorization
Route::get('/', function () {
    return view('auth/login');
});

Route::post('login', [AuthController::class, 'login'])->name('login');
Route::get('login', [AuthController::class, 'showLoginForm'])->name('logins');
// Route::get('register', [AuthController::class, 'showRegistrationForm'])->name('register');
Route::get('logout', [AuthController::class, 'logout'])->name('logout');
Route::get('profile', [AuthController::class, 'showProfile'])->name('profile');
Route::get('reset', [AuthController::class, 'showForgetPasswordForm'])->name('reset');
Route::get('reset-pass', [AuthController::class, 'resetPasswordForm'])->name('reset-pass');
Route::post('new-pass/{id}', [AuthController::class, 'newPasswordForm'])->name('new-pass');
Route::get('restore', [AuthController::class, 'showRestore'])->name('restore');

Route::get('notification', [AuthController::class, 'showNotification'])->name('notification');
Route::post('delete-notification', [AuthController::class, 'deleteNotification'])->name('delete-notification');
Route::post('markRead-notification', [AuthController::class, 'markAsRead'])->name('markRead-notification');
Route::get('click-notification/{notification_id}', [AuthController::class, 'clickNotification'])->name('click-notification');

//Dashboard
Route::get('dashboard', [DashboardController::class, 'showDashboard'])->name('dashboard');
Route::put('update-lowstock/{sp_id}', [DashboardController::class, 'updateLowStock'])->name('update-lowstock');

//Supply Management
Route::get('supply', [SupplyController::class, 'showSupply'])->name('supply');
Route::get('edit-supply/{supplier_id}', [SupplyController::class, 'showEditSupplier'])->name('edit-supply');
Route::post('add-supplier-individual', [SupplyController::class, 'addSupplierIndividual'])->name('add-supplier-individual');
Route::get('download-template', [SupplyController::class, 'downloadTemplate'])->name('download-template');
Route::post('add-supplier-bulk', [SupplyController::class, 'addSupplierBulk'])->name('add-supplier-bulk');
Route::put('udpate-supplier/{supplier_id}', [SupplyController::class, 'updateSupplier'])->name('update-supplier');
Route::get('delete-supplier/{supplier_id}', [SupplyController::class, 'deleteSupplier'])->name('delete-supplier');
Route::get('restore-supplier/{supplier_id}', [SupplyController::class, 'restoreSupplier'])->name('restore-supplier');
Route::get('permanent-delete-supplier/{supplier_id}', [SupplyController::class, 'permanentDeleteSupplier'])->name('permanent-delete-supplier');
Route::get('download-supplier', [SupplyController::class, 'downloadAllSupplier'])->name('download-supplier');

//Inventory Tracking
Route::get('spare-part', [InventoryController::class, 'showSparePart'])->name('spare-part');
Route::post('add-sparepart', [InventoryController::class, 'addSparePart'])->name('add-sparepart');
Route::get('download-template-sparepart', [InventoryController::class, 'downloadTemplateSparepart'])->name('download-template-sparepart');
Route::post('add-sparepart-bulk', [InventoryController::class, 'addSparePartBulk'])->name('add-sparepart-bulk');
Route::get('edit-sparepart/{sp_id}', [InventoryController::class, 'showEditSparePart'])->name('edit-sparepart');
Route::put('update-sparepart/{sp_id}', [InventoryController::class, 'updateSparePart'])->name('update-sparepart');
Route::get('delete-sparepart/{sp_id}', [InventoryController::class, 'deleteSparePart'])->name('delete-sparepart');
Route::get('restore-sparepart/{sp_id}', [InventoryController::class, 'restoreSparePart'])->name('restore-sparepart');
Route::get('permanent-delete-sparepart/{sp_id}', [InventoryController::class, 'permanentDeleteSparePart'])->name('permanent-delete-sparepart');
Route::post('multi-sparepart-excel', [InventoryController::class, 'downloadMultiExcel'])->name('multi-sparepart-excel');
Route::get('single-sparepart-excel/{sp_id}/{type}', [InventoryController::class, 'downloadSingleExcel'])->name('single-sparepart-excel');
Route::get('download-attachment/{sp_id}/{file}', [InventoryController::class, 'downloadAttachment'])->name('download-attachment');



Route::get('stockinout', [InventoryController::class, 'showStockInOut'])->name('stockinout');
Route::get('stockout', [InventoryController::class, 'showStockOut'])->name('stockout');
Route::get('addstockin', [InventoryController::class, 'showAddStockIn'])->name('addstockin');
Route::get('addstockout', [InventoryController::class, 'showAddStockOut'])->name('addstockout');
Route::get('delete-stock/{si_id}', [InventoryController::class, 'deleteStock'])->name('delete-stock');
Route::put('updatestock/{si_id}', [InventoryController::class, 'updateStock'])->name('updatestock');
Route::post('updatestockin', [InventoryController::class, 'updateStockIn'])->name('updatestockin');
Route::put('updatestockout', [InventoryController::class, 'updateStockOut'])->name('updatestockout');
Route::get('restore-stock/{si_id}', [InventoryController::class, 'restoreStock'])->name('restore-stock');
Route::get('permanent-delete-stock/{si_id}', [InventoryController::class, 'permanentDeleteStock'])->name('permanent-delete-stock');
Route::get('edit-stockinout/{si_id}', [InventoryController::class, 'showEditStockInOut'])->name('edit-stockinout');
Route::put('update-stockinout-form/{si_id}', [InventoryController::class, 'updateStockInOutForm'])->name('update-stockinout-form');
Route::get('addsinglestockin/{sp_id}', [InventoryController::class, 'showAddSingleStockIn'])->name('addsinglestockin');

//Budgeting
Route::get('budgeting', [BudgetController::class, 'showBudget'])->name('budgeting');
Route::get('edit-budget/{budget_id}', [BudgetController::class, 'showEditBudget'])->name('edit-budget');
Route::put('update-budget/{budget_id}', [BudgetController::class, 'updateBudget'])->name('update-budget');
Route::get('department', [BudgetController::class, 'showDepartment'])->name('department');
Route::post('add-budget', [BudgetController::class, 'addBudget'])->name('add-budget');
Route::get('delete-budget/{budget_id}', [BudgetController::class, 'deleteBudget'])->name('delete-budget');
Route::get('restore-budget/{budget_id}', [BudgetController::class, 'restoreBudget'])->name('restore-budget');
Route::get('permanent-delete-budget/{budget_id}', [BudgetController::class, 'permanentDeleteBudget'])->name('permanent-delete-budget');

Route::post('add-department', [BudgetController::class, 'addDepartment'])->name('add-department');
Route::put('update-department/{department_id}', [BudgetController::class, 'updateDepartment'])->name('update-department');
Route::get('delete-department/{department_id}', [BudgetController::class, 'deleteDepartment'])->name('delete-department');
Route::get('restore-department/{department_id}', [BudgetController::class, 'restoreDepartment'])->name('restore-department');
Route::get('permanent-delete-department/{department_id}', [BudgetController::class, 'permanentDeleteDepartment'])->name('permanent-delete-department');

//System Management
Route::get('usercontrol', [SystemManagementController::class, 'showUserAccessControl'])->name('usercontrol');
Route::get('modulesetup', [SystemManagementController::class, 'showModulePageSetup'])->name('modulesetup');
Route::get('role', [SystemManagementController::class, 'showRole'])->name('role');
Route::post('add-role', [SystemManagementController::class, 'addRole'])->name('add-role');
Route::put('update-role/{ur_id}', [SystemManagementController::class, 'updateRole'])->name('update-role');
Route::get('delete-role/{ur_id}', [SystemManagementController::class, 'deleteRole'])->name('delete-role');
Route::get('restore-role/{ur_id}', [SystemManagementController::class, 'restoreRole'])->name('restore-role');
Route::get('permanent-delete-role/{ur_id}', [SystemManagementController::class, 'permanentDeleteRole'])->name('permanent-delete-role');

Route::post('add-user', [SystemManagementController::class, 'addUser'])->name('add-user');
Route::get('edit-user/{id}', [SystemManagementController::class, 'showEditUser'])->name('edit-user');
Route::put('update-user/{id}', [SystemManagementController::class, 'updateUser'])->name('update-user');
Route::get('delete-user/{id}', [SystemManagementController::class, 'deleteUser'])->name('delete-user');
Route::put('edit-permission', [SystemManagementController::class, 'editPermission'])->name('edit-permission');

Route::get('itemstatus', [SystemManagementController::class, 'showItemStatus'])->name('itemstatus');
Route::put('update-status/{is_id}', [SystemManagementController::class, 'updateItemStatus'])->name('update-status');

//Audit Trail
Route::get('audit', [AuditController::class, 'showAuditTrail'])->name('audit');
Route::get('audit-single-pdf/{at_id}', [AuditController::class, 'downloadSingleAudit'])->name('audit-single-pdf');
Route::get('audit-multi-pdf', [AuditController::class, 'downloadMultiAudit'])->name('audit-multi-pdf');
Route::get('audit-all-pdf', [AuditController::class, 'downloadAllAudit'])->name('audit-all-pdf');




