<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
    <title>HRS - Inventory</title>
    <link href="{{asset('extra-libs/c3/c3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
    <link href="{{asset('libs/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="{{route('dashboard')}}" class="brand-logo">
                        <span class="icon">
                            <img class="light-logo" src="{{asset('images/hrs.png')}}" width="36%" style="margin-top: 16px;">
                            {{-- <img class="dark-logo" src="{{asset('images/logo-icon.png')}}"> --}}
                        </span>
                        {{-- <span class="text">
                            <img class="light-logo" src="{{asset('images/logo-light-text.png')}}">
                            <img class="dark-logo" src="{{asset('images/logo-text.png')}}">
                        </span> --}}
                    </a>

                    <ul class="right">
                        @php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($restore != 0)
                        <li><a href="{{route('restore')}}" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        @endif
                        {{-- <li><a href="" class="tooltipped" data-tooltip="Refresh"><i class="material-icons">refresh</i></a></li> --}}


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            @if ($new_notification != 0)
                                <span class="notification-badge">{{ $new_notification }}</span>
                            @endif
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        @foreach ($notification as $notifications)
                                            <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        {{$notifications->notification_title}}
                                                        @if ($notifications->notification_is_read == 0)
                                                            <span class="label label-success m-r-10">New</span>
                                                        @endif
                                                    </h5>
                                                    <span class="mail-desc">{{$notifications->notification_subtitle}}</span> <span class="time">{{date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')}}</span>
                                                </span>
                                            </a>
                                        @endforeach
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="{{route('notification')}}"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger tooltipped" data-tooltip="Profile" href="javascript: void(0);" data-target="user_dropdown"><img src="{{asset('images/users/2.jpg')}}" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="{{asset('images/users/2.jpg')}}" alt="user"></div>
                                        <div class="u-text">
                                            <h4>{{Auth::user()->name}}</h4>
                                            <p>{{Auth::user()->email}}</p>
                                            {{-- <a class="waves-effect waves-light btn-small red white-text">View Profile</a> --}}
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('profile')}}"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="{{route('reset')}}"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('logout')}}"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> {{--class="side-wrap" --}}
                    <ul class="collapsible">
                        {{-- <li class="small-cap"><span class="hide-menu">PERSONAL</span></li> --}}
                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('supply')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($inventory != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('spare-part')}}"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                         @if ($permission != 0)
                                            {{-- <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In/Out</span></a></li> --}}
                                            <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="{{route('stockout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($budget != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('budgeting')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('department')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($system != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('usercontrol')}}"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('modulesetup')}}"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('itemstatus')}}"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        @endif
                                        {{-- <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Role</span></a></li>
                                        <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Audit Trail</span></a></li> --}}
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('audit')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    </ul>
                </li>
            </ul>
        </aside>

        {{-- <div class="page-wrapper"> --}}
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Supplier Profile ({{$total}} Supplier)</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    <div class="table-responsive">
                                        {{-- <a class="waves-effect waves-light btn indigo right modal-trigger" href="#modal1">Add Supplier</a> --}}
                                        @php
                                            $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                    ->where('up_module', 'Supply Management')
                                                    ->where('id', Auth::user()->id)
                                                    ->value('is_create');
                                        @endphp
                                        <div class="dropdown2">
                                            <a href="#modal3" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                        </div>
                                        @if ($create == 1)
                                            <div class="dropdown2 right">
                                                <button class=" waves-effect waves-light btn indigo right" onclick="toggleDropdown()">Add Supplier</button>
                                                <div id="dropdown-content">
                                                    <a href="#modal1" class="modal-trigger" onclick="selectOption('individual')">Individual</a>
                                                    <a href="#modal2" class="modal-trigger" onclick="selectOption('bulk')">Bulk</a>
                                                    <a href="{{route('download-template')}}" onclick="selectOption('template')">Download Template</a>
                                                </div>
                                            </div>
                                        @endif
                                        <br>

                                        @if(count($errors) > 0)
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Supplier New Code</th>
                                                    <th>Supplier Old Code</th>
                                                    <th>Supplier Name</th>
                                                    <th>Control Account</th>
                                                    <th>Vendor Group</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            @if(session('error'))
                                            <script>
                                                alert("{{ session('error') }}");
                                            </script>
                                            @endif
                                            @if(session('error2'))
                                            <script>
                                                alert("{{ session('error2') }}");
                                            </script>
                                            @endif

                                            <tbody>
                                                @php
                                                   $no = 1;
                                                   $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                            ->where('up_module', 'Supply Management')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_update');
                                                    $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                            ->where('up_module', 'Supply Management')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_delete');
                                                @endphp
                                                @foreach ($supplier as $supply)
                                                <tr>
                                                    <td>{{$no}}</td>
                                                    <td>{{$supply->supplier_newcode}}</td>
                                                    <td>{{$supply->supplier_oldcode}}</td>
                                                    <td>{{$supply->supplier_name}}</td>
                                                    <td>{{$supply->supplier_control_acc}}</td>
                                                    <td>{{$supply->supplier_vendor_group}}</td>
                                                    <td class="center">
                                                        @if ($update == 1)
                                                        <a href="{{route('edit-supply', $supply->supplier_id)}}"><span class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit" ></i></span></a>
                                                        @endif
                                                        @if ($delete == 1)
                                                        <span class="label label-ready tooltipped sa-delete" data-supplier-id="{{$supply->supplier_id}}" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @php
                                                    $no++;
                                                @endphp
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <a class='dropdown-trigger waves-effect waves-light btn indigo right' href='{{route('download-supplier')}}' data-target='dropdown1'>Download</a>
                                    </div>

                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        {{-- </div> --}}

<!-- Modal Add Supplier Individual -->
<div id="modal1" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Supplier</h4>
	<form method="POST" action="{{route('add-supplier-individual')}}" id="form">
    @csrf
		<div class="row">
            <div class="input-field col s12 l6">
                <input id="old_code" name="old_code" type="text">
                <label for="old_code">Supplier Old Code</label>
            </div>
            <div class="input-field col s12 l6">
                <input id="new_code" name="new_code" type="text" required>
                <label for="new_code">Supplier New Code*</label>
            </div>
            <div class="input-field col s12 l6">
                <input id="name" name="name" type="text" required>
                <label for="name">Supplier Name*</label>
            </div>
            <div class="input-field col s12 l6">
                <input id="acc" name="acc" type="text">
                <label for="acc">Control Account</label>
            </div>
            <div class="input-field col s12 l6">
                <input id="vendor" name="vendor" type="text">
                <label for="vendor">Vendor Group</label>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="add-supplier" class="waves-effect waves-light btn indigo right">Add</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>


<!-- Modal Add Supplier Bulk -->
<div id="modal2" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Supplier</h4>
	<form method="POST" action="{{route('add-supplier-bulk')}}" enctype="multipart/form-data">
    @csrf
		<div class="row">
            <div class="file-field input-field">
                <div class="btn blue darken-1">
                    <span>File</span>
                    <input type="file" name="file" required>
                </div>
                <div class="file-path-wrapper">
                    <input class="file-path validate" type="text">
                </div>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="add-supplier" class="waves-effect waves-light btn indigo right modal-trigger">Add</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Filter Modal-->
<div id="modal3" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Filter Supplier</h4>
	<form method="GET" action="{{route('supply')}}" id="form">
    @csrf
		<div class="row">
            <div class="input-field col s12 l6">
                <h6 class="labelform">Supplier Old Code</h6>
                <input type="text" list="old_codes" placeholder="Supplier Old Code" name="old_code" />
                <datalist id="old_codes">
                    @foreach ($filter_oldcode as $oldcode)
                    <option value="{{$oldcode}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="old_code" name="old_code">
                <option value="" selected>No Old Code Selected</option>
                @foreach ($filter_oldcode as $oldcode)
                <option value="{{$oldcode}}">{{$oldcode}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Supplier New Code</h6>
                <input type="text" list="new_codes" placeholder="Supplier New Code" name="new_code" />
                <datalist id="new_codes">
                    @foreach ($filter_newcode as $new_code)
                    <option value="{{$new_code}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="new_code" name="new_code">
                <option value="" selected>No New Code Selected</option>
                @foreach ($filter_newcode as $new_code)
                <option value="{{$new_code}}">{{$new_code}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l12">
                <h6 class="labelform">Supplier Name</h6>
                <input type="text" list="supplier" placeholder="Supplier Name" name="supplier_name" />
                <datalist id="supplier">
                    @foreach ($filter_supplier as $supplier)
                    <option value="{{$supplier}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="name" name="supplier_name">
                <option value="" selected>No Supplier Selected</option>
                @foreach ($filter_supplier as $supplier)
                <option value="{{$supplier}}">{{$supplier}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Control Account</h6>
                <input type="text" list="control_acc" placeholder="Control Account" name="control_acc" />
                <datalist id="control_acc">
                    @foreach ($filter_control as $control_acc)
                    <option value="{{$control_acc}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="acc" name="control_acc">
                <option value="" selected>No Control Acc Selected</option>
                @foreach ($filter_control as $control_acc)
                <option value="{{$control_acc}}">{{$control_acc}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l6">
                <h6 class="vendor">Vendor Group</h6>
                <input type="text" list="vendors" placeholder="Vendor Group" name="vendor" />
                <datalist id="vendors">
                    @foreach ($filter_vendor as $vendor)
                    <option value="{{$vendor}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="vendor" name="vendor">
                <option value="" selected>No Vendor Group Selected</option>
                @foreach ($filter_vendor as $vendor)
                <option value="{{$vendor}}">{{$vendor}}</option>
                @endforeach
                </select> --}}
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                    <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
    <script src="{{asset('js/materialize.min.js')}}"></script>
    <script src="{{asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')}}"></script>
    <script src="{{asset('js/app.js')}}"></script>
    <script src="{{asset('js/app.init.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.js')}}"></script>

    <script src="{{asset('js/custom.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/d3.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/c3.min.js')}}"></script>
    <script src="{{asset('extra-libs/DataTables/jquery.dataTables.min.js')}}"></script>
    {{-- <script src="{{asset('js/pages/datatable/datatable-basic.init.js')}}"></script> --}}
    <script src="{{asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')}}"></script>
    {{-- <script src="{{asset('extra-libs/tiny-editable/mindmup-editabletable.js')}}"></script>
    <script src="{{asset('extra-libs/tiny-editable/numeric-input-example.js')}}"></script> --}}
    <script src="{{asset('libs/sweetalert2/dist/sweetalert2.min.js')}}"></script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();

    });

    $(document).ready(function() {
        $('#add-supplier').click(function() {
            event.preventDefault();

            // Check if all required inputs are filled
            var isFormValid = true;
            $('#form input[required]').each(function() {
                if ($(this).val() === '') {
                isFormValid = false;
                return false; // Exit the loop if an empty required input is found
                }
            });

            if(isFormValid){
                var addButton = $(this);
                swal({
                    title: "Are you sure?",
                    text: "Are you sure want to add new supplier?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    closeOnConfirm: false
                    }).then((result) => {
                    if (result.value) {
                        addButton.closest("form").submit();
                    }
                    });
            } else {
                alert("Please fill all required fields before adding a new supplier.");
            }

        });
    });

    $('.sa-delete').click(function() {
    var deleteButton = $(this); // Store the reference to the delete button
      swal({
          title: "Are you sure?",
          text: "This supplier will be deleted!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('supplier-id');
            var deleteUrl = "{{ route('delete-supplier', ['supplier_id' => 'TEMP_ID']) }}";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

    <script>
        function toggleDropdown() {
            var dropdownContent = document.getElementById("dropdown-content");
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        }
    </script>
    <script>
    function selectOption(option) {
        console.log('Selected option:', option);
    }
    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        var elems = document.querySelectorAll('.modal');
        var instances = M.Modal.init(elems);
    });
    </script>

</body>
</html>

