<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
    <title>HRS - Inventory</title>
    <link href="{{asset('extra-libs/c3/c3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
    <link href="{{asset('libs/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet" type="text/css">
    <link href="{{asset('css/select2.css')}}" rel="stylesheet">

    @csrf

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="{{route('dashboard')}}" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="{{asset('images/hrs.png')}}" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="{{asset('images/hrs.png')}}" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        @php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($restore != 0)
                        <li><a href="{{route('restore')}}" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        @endif
                        {{-- <li><a href="" class="tooltipped" data-tooltip="Refresh"><i class="material-icons">refresh</i></a></li> --}}

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            @if ($new_notification != 0)
                                <span class="notification-badge">{{ $new_notification }}</span>
                            @endif
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        @foreach ($notification as $notifications)
                                            <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        {{$notifications->notification_title}}
                                                        @if ($notifications->notification_is_read == 0)
                                                            <span class="label label-success m-r-10">New</span>
                                                        @endif
                                                    </h5>
                                                    <span class="mail-desc">{{$notifications->notification_subtitle}}</span> <span class="time">{{date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')}}</span>
                                                </span>
                                            </a>
                                        @endforeach
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="{{route('notification')}}"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="{{asset('images/users/2.jpg')}}" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="{{asset('images/users/2.jpg')}}" alt="user"></div>
                                        <div class="u-text">
                                            <h4>{{Auth::user()->name}}</h4>
                                            <p>{{Auth::user()->email}}</p>
                                            {{-- <a class="waves-effect waves-light btn-small red white-text">View Profile</a> --}}
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('profile')}}"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="{{route('reset')}}"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('logout')}}"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> {{--class="side-wrap" --}}
                    <ul class="collapsible">
                        {{-- <li class="small-cap"><span class="hide-menu">PERSONAL</span></li> --}}
                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('supply')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($inventory != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('spare-part')}}"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                         @if ($permission != 0)
                                            {{-- <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In/Out</span></a></li> --}}
                                            <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="{{route('stockout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($budget != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('budgeting')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('department')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($system != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('usercontrol')}}"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('modulesetup')}}"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('itemstatus')}}"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        @endif
                                        {{-- <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Role</span></a></li>
                                        <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Audit Trail</span></a></li> --}}
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('audit')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    </ul>
                </li>
            </ul>
        </aside>

        {{-- <div class="page-wrapper"> --}}
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Spare Part</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    @if(session('excel'))
                                        <script>
                                            alert('Please make a selection of the dataset for data generation within Excel.', 'TEST');
                                        </script>
                                    @endif
                                    {{-- @if(session('error2'))
                                        <script>
                                            alert('Kindly input numerical values in the Unit Price, Opening Stock, and Minimum Safety Stock columns.', 'TEST');
                                        </script>
                                    @endif --}}
                                    @if(session('error3'))
                                        <script>
                                            alert('Sorry, only JPG, JPEG, PNG, PDF & TIF files are allowed.', 'TEST');
                                        </script>
                                    @endif
                                    @if(session('error4'))
                                        <script>
                                            alert('Sorry, the maximum allowable file size is limited to 200 MB.', 'TEST');
                                        </script>
                                    @endif
                                    @if(session('month'))
                                        <script>
                                            alert('Budget Month does not exist.', 'TEST');
                                        </script>
                                    @endif
                                    @if(session('error_solo1'))
                                        <script>
                                            alert('Item number with supplier name already exists.', 'TEST');
                                        </script>
                                    @endif
                                    @if(session('error_solo2'))
                                        <script>
                                            alert('Item number with supplier name already exists in restore module.', 'TEST');
                                        </script>
                                    @endif
                                    @if(session('errors'))
                                        <div class="alert alert-danger" style="background-color: #FF5050; color:white; border-radius:5px;">
                                            <ul>
                                                @foreach(session('errors') as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif

                                    {{-- <iframe id="download-frame" name="download-frame" style="display: none;"></iframe>

                                    <div id="loading-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 9999;">
                                        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">
                                            <h2>Please wait...</h2>
                                        </div>
                                    </div> --}}

                                    <div class="table-responsive">
                                        @php
                                            $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                            ->where('up_module', 'Spare Part')
                                                            ->where('id', Auth::user()->id)
                                                            ->value('is_create');
                                        @endphp

                                        <div class="dropdown2">
                                            <a href="#modal4" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                        </div>

                                        @if ($create == 1)
                                        {{-- <a class="waves-effect waves-light btn indigo right modal-trigger" href="#modal1">Add Spare Part</a> --}}
                                        <div class="dropdown2 right">
                                            <button class="waves-effect waves-light btn indigo right" onclick="toggleDropdown()">Add Spare Part</button>
                                            <div id="dropdown-content">
                                                <a href="#modal1" class="modal-trigger" onclick="selectOption('individual')">Individual</a>
                                                <a href="#modal2" class="modal-trigger" onclick="selectOption('bulk')">Bulk</a>
                                                <a href="{{route('download-template-sparepart')}}" onclick="selectOption('template')">Download Template</a>
                                            </div>
                                        </div>
                                        @endif
                                        <br>
                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    {{-- <th>
                                                        <label>
                                                            <input type="checkbox" name="check-all" id="check-all">
                                                            <span></span>
                                                        </label>
                                                    </th> --}}
                                                    <th>#</th>
                                                    <th>Series</th>
                                                    <th>Item No</th>
                                                    <th>Line No.</th>
                                                    <th>Die Name</th>
                                                    <th>Description</th>
                                                    <th>Supplier</th>
                                                    <th>Unit Price</th>
                                                    <th class="center">Current Stock</th>
                                                    <th class="center">Minimum Safety Stock</th>
                                                    <th>Department</th>
                                                    <th>Location</th>
                                                    <th>Item Status</th>
                                                    <th class="center">Rank</th>
                                                    <th class="center">Drawing</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                    $no = 1;
                                                @endphp
                                                @foreach ($spare_part as $part)
                                                <tr id="item-{{$part->sp_id}}">
                                                    {{-- <td>
                                                        <label>
                                                            <input type="checkbox" name="check" class="check" id="check" value="{{$part->sp_id}}">
                                                            <span></span>
                                                        </label>
                                                    </td> --}}
                                                    <td>{{$no}}</td>
                                                    <td>{{$part->sp_series}} </td>
                                                    <td>{{$part->sp_itemno}} </td>
                                                    <td>{{$part->sp_line}}</td>
                                                    <td>{{$part->sp_die_name}}</td>
                                                    <td>{{$part->sp_desc}}</td>
                                                    <td>{{$part->supplier_name}}</td>
                                                    <td>RM{{$part->sp_unitprice}}</td>
                                                    <td class="center">{{$part->sp_opening_stock}}</td>
                                                    <td class="center">{{$part->sp_min_stock}}</td>
                                                    <td>{{$part->department_name}}</td>
                                                    <td>{{$part->sp_location}}</td>
                                                    <td>
                                                        @if($part->sp_status == 2)
                                                        Slow moving
                                                        @elseif($part->sp_status == 1)
                                                        Active
                                                        @else
                                                        Non-active
                                                        @endif
                                                    </td>
                                                    <td class="center">{{$part->sp_rank}}</td>
                                                    @php
                                                        $link = "https://demo1.tamarix.com.my/hrsinventory/storage/app/spare_part/".$part->sp_id."/".$part->sp_drawing;
                                                    @endphp
                                                    <td class="center"><a href="{{$link}}" target="blank">{{$part->sp_drawing}}</a></td>
                                                    <td class="center">
                                                        @php
                                                            $update = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Spare Part')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_update');
                                                            $delete = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Spare Part')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_delete');
                                                        @endphp
                                                        @if ($update == 1)
                                                        <a href="{{route('edit-sparepart', $part->sp_id)}}" ><span class="label label-blue tooltipped" data-tooltip="Edit"><i class="fas fa-edit" ></i></span></a>
                                                        @endif
                                                        @if ($delete == 1)
                                                        <span class="label label-ready tooltipped sa-delete" data-sparepart-id="{{$part->sp_id}}" data-tooltip="Delete"><i class="fas fa-trash-alt "></i></span>
                                                        @endif
                                                        {{-- <a href="#"><span class="label label-orange dropdown-trigger tooltipped" data-target='dropdown3' data-tooltip="Download"><i class="fas fa-download"></i></span></a>
                                                        <ul id='dropdown3' class='dropdown-content'>
                                                            <li><a href="{{ route('single-sparepart-excel', ['sp_id' => $part->sp_id, 'type' => 'pdf']) }}">PDF</a></li>
                                                            <li class="divider"></li>
                                                            <li><a href="{{ route('single-sparepart-excel', ['sp_id' => $part->sp_id, 'type' => 'excel']) }}">Excel</a></li>

                                                        </ul> --}}
                                                    </td>
                                                </tr>
                                                @php
                                                    $no++;
                                                @endphp
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <br>
                                    {{-- <a class='dropdown-trigger waves-effect waves-light btn indigo right' href='#' data-target='dropdown1'>Download</a>
                                        <ul id='dropdown1' class='dropdown-content'>
                                            <li><a href="#!">PDF</a></li>
                                            <li class="divider"></li>
                                            <li><a href="#" id="excel-option">Excel</a></li>
                                        </ul>
                                    <br><br> --}}
                                    <a class="waves-effect waves-light btn indigo right modal-trigger" href="#modal3">Download Report</a><br><br>
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        {{-- </div> --}}

<!-- Modal Add Supplier -->
<div id="modal1" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Spare Part</h4>
	<form id="form" method="POST" action="{{route('add-sparepart')}}" enctype="multipart/form-data">
    @csrf
		<div class="row">
            <div class="input-field col s12">
                <h6 class="labelform">Supplier Name*</h6>
                <select id="name" name="name" required>
                @foreach ($supplier as $suppliers)
                <option value="{{$suppliers->supplier_id}}">{{$suppliers->supplier_name}}</option>
                @endforeach
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Spare Part Category*</h6>
                <select id="category" name="category" onchange="toggleButtons()" required>
                    <option value="SS" selected>SS</option>
                    <option value="SK">SK</option>
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Series</h6>
                <input id="series" name="series" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Department</h6>
                @php
                    $department_name = DB::table('department')->where('department_id', Auth::user()->user_department_id)->value('department_name');
                @endphp
                <input id="department" name="department" value="{{$department_name}}" disabled>
                {{-- <select id="department" name="department">
                @foreach ($department as $departments)
                <option value="{{$departments->department_id}}">{{$departments->department_name}}</option>
                @endforeach
                </select> --}}
            </div>
        </div>
		<div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item No*</h6>
                <input id="itemno" name="itemno" type="text" required>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Lot No</h6>
                <input id="itemlotno" name="itemlotno" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Line</h6>
                <input id="line" name="line" type="text" placeholder="eg: HSI-XXX">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Location</h6>
                <input id="location" name="location" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Unit Price</h6>
                <input id="unit" name="unit" type="number">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Stock</h6>
                <input id="stock" name="stock" type="number">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Amount (RM)</h6>
                <input id="amount" name="amount" type="number" readonly placeholder="RM">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Minimum Safety Stock</h6>
                <input id="min" name="min" type="number">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Description</h6>
                <input id="desc" name="desc" type="text">
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Die Name</h6>
                <input id="die" name="die" type="text">
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Rank</h6>
                <select id="rank" name="rank">
                <option value="A">A</option>
                <option value="B">B</option>
                <option value="C">C</option>
                <option value="D">D</option>
                <option value="E">E</option>
                </select>
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Status</h6>
                <select id="status" name="status">
                <option value="1">Active</option>
                <option value="0">Non-active</option>
                <option value="2">Slow moving</option>
                </select>
            </div>
        </div>
        <div class="row" id="drawing" style="display: none;">
            <div class="input-field col s12">
                <h6 class="labelform">Drawing</h6>
                <input id="drawing" name="drawing" type="file">
                {{-- <select id="drawing" name="drawing">
                    <option value="">Please Select</option>
                    <option value="1">Active</option>
                    <option value="0">Non-active</option>
                </select> --}}
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <a href="#" id="modalbutton"><button  id="add-sparepart" class="waves-effect waves-light btn indigo right">Add</button></a>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Modal Add Spare Part Bulk -->
<div id="modal2" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Add Spare Part</h4>
	<form method="POST" action="{{route('add-sparepart-bulk')}}" enctype="multipart/form-data">
    @csrf
		<div class="row">
            {{-- <div class="input-field col s12 l6">
                <h6 class="labelform">Supplier Name*</h6>
                <select id="name" name="name" required>
                @foreach ($supplier as $suppliers)
                <option value="{{$suppliers->supplier_id}}">{{$suppliers->supplier_name}}</option>
                @endforeach
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Spare Part Category*</h6>
                <select id="category2" name="category" onchange="toggleButtons2()" required>
                    <option value="SS" selected>SS</option>
                    <option value="SK">SK</option>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Department</h6>
                <select id="department" name="department" required>
                @foreach ($department as $departments)
                <option value="{{$departments->budget_id}}">{{$departments->department_name}} / {{date_format(new DateTime($departments->budget_month), 'm-Y')}}</option>
                @endforeach
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Rank</h6>
                <select id="rank" name="rank">
                <option value="A">A</option>
                <option value="B">B</option>
                <option value="C">C</option>
                <option value="D">D</option>
                <option value="E">E</option>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Item Status</h6>
                <select id="status" name="status">
                <option value="1">Active</option>
                <option value="0">Non-active</option>
                <option value="2">Slow moving</option>
                </select>
            </div>
            <div class="input-field col s12 l6" id="drawing2" style="display: none;">
                <h6 class="labelform">Drawing</h6>
                <input id="drawing" name="drawing" type="text">
            </div> --}}
            <div class="file-field col s12">
                <br><div class="btn blue darken-1">
                    <span>File</span>
                    <input type="file" name="file" required>
                </div>
                <div class="file-path-wrapper">
                    <input class="file-path validate" type="text">
                </div>
            </div>
        </div><br>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="add-supplier" class="waves-effect waves-light btn indigo right modal-trigger">Add</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Modal Download Spare Part Report -->
<div id="modal3" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Download Spare Part Report</h4>
	<form method="POST" action="{{route('multi-sparepart-excel')}}" enctype="multipart/form-data" id="download-form">
    @csrf
		<div class="row">
            <div class="input-field col s12 l6">
                <h6 class="labelform">Department</h6>
                <select id="department" name="department[]" required multiple>
                <option value="" disabled>Choose your department</option>
                @foreach ($department as $departments)
                <option value="{{$departments->department_id}}">{{$departments->department_name}}</option>
                @endforeach
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Type</h6>
                <select id="type" name="type" required>
                <option value="excel">Excel</option>
                <option value="pdf">PDF</option>
                </select>
            </div>
            <div class="input-field col s12 l6">
                <h6 class="labelform">Month</h6>
                <input id="month" name="month" type="month" required>
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button id="download" class="waves-effect waves-light btn indigo right modal-trigger">Download</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

<!-- Filter Modal-->
<div id="modal4" class="modal modal-fixed-footer">
	<div class="modal-content">
	<h4 class="modalheader">Filter Supplier</h4>
	<form method="GET" action="{{route('spare-part')}}" id="form">
    @csrf
        <div class="row">
            <div class="input-field col s12">
                <h6 class="labelform">Supplier Name</h6>
                <input type="text" list="supplier" placeholder="Supplier Name" name="supplier" />
                <datalist id="supplier">
                    @foreach ($supplier as $suppliers)
                    <option value="{{$suppliers->supplier_name}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="supplier" name="supplier">
                <option value="" selected>No Supplier Selected</option>
                @foreach ($supplier as $suppliers)
                <option value="{{$suppliers->supplier_id}}">{{$suppliers->supplier_name}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Spare Part Category</h6>
                <input type="text" list="categories" placeholder="Category" name="category" />
                <datalist id="categories">
                    <option value="SS"></option>
                    <option value="SK"></option>
                </datalist>
                {{-- <select id="category" name="category">
                    <option value="" selected>No Category Selected</option>
                    <option value="SS">SS</option>
                    <option value="SK">SK</option>
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Series</h6>
                <input type="text" list="serie" placeholder="Series" name="series" />
                <datalist id="serie">
                @foreach ($filter_series as $series)
                <option value="{{$series}}"></option>
                @endforeach
                </datalist>
                {{-- <select id="series" name="series">
                <option value="" selected>No Series Selected</option>
                @foreach ($filter_series as $series)
                <option value="{{$series}}">{{$series}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Department</h6>
                <input type="text" list="departments" placeholder="Department" name="department" />
                <datalist id="departments">
                    @foreach ($department as $departments)
                    <option value="{{$departments->department_name}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="department" name="department">
                <option value="" selected>No Department Selected</option>
                @foreach ($department as $departments)
                <option value="{{$departments->department_id}}">{{$departments->department_name}}</option>
                @endforeach
                </select> --}}
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item No</h6>
                <input type="text" list="filteritemno" placeholder="Item No" name="itemno" />
                <datalist id="filteritemno">
                    @foreach ($filter_itemno as $itemno)
                    <option value="{{$itemno}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="itemno" name="itemno">
                <option value="" selected>No Item No Selected</option>
                @foreach ($filter_itemno as $itemno)
                <option value="{{$itemno}}">{{$itemno}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Line</h6>
                <input type="text" list="lines" placeholder="Line" name="line" />
                <datalist id="lines">
                @foreach ($filter_line as $line)
                <option value="{{$line}}"></option>
                @endforeach
                </datalist>
                {{-- <h6 class="labelform">Line</h6>
                <select class="browser-default" data-live-search="true" id="line" name="line">
                <option value="" selected>No Line Selected</option>
                @foreach ($filter_line as $line)
                <option value="{{$line}}">{{$line}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Location</h6>
                <input type="text" list="locationss" placeholder="Location" name="location" />
                <datalist id="locationss">
                    @foreach ($filter_location as $location)
                    <option value="{{$location}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="location" name="location">
                <option value="" selected>No Series Selected</option>
                @foreach ($filter_location as $location)
                <option value="{{$location}}">{{$location}}</option>
                @endforeach
                </select> --}}
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Unit Price</h6>
                <input type="text" list="unitss" placeholder="Price" name="unit" />
                <datalist id="unitss">
                    @foreach ($filter_unit as $unit)
                    <option value="{{$unit}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="unit" name="unit">
                <option value="" selected>No Unit Price Selected</option>
                @foreach ($filter_unit as $unit)
                <option value="{{$unit}}">{{$unit}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Opening Stock</h6>
                <input type="text" list="stockss" placeholder="Stock" name="stock" />
                <datalist id="stockss">
                    @foreach ($filter_stock as $stock)
                <option value="{{$stock}}"></option>
                @endforeach
                </datalist>
                {{-- <select id="stock" name="stock">
                <option value="" selected>No Opening Stock Selected</option>
                @foreach ($filter_stock as $stock)
                <option value="{{$stock}}">{{$stock}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Minimum Safety Stock</h6>
                <input type="text" list="minss" placeholder="Min Stock" name="min" />
                <datalist id="minss">
                    @foreach ($filter_min as $min)
                    <option value="{{$min}}">{{$min}}</option>
                    @endforeach
                </datalist>
                {{-- <select id="min" name="min">
                <option value="" selected>No Minimum Safety Stock Selected</option>
                @foreach ($filter_min as $min)
                <option value="{{$min}}">{{$min}}</option>
                @endforeach
                </select> --}}
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Description</h6>
                <input type="text" list="descss" placeholder="Description" name="desc" />
                <datalist id="descss">
                    @foreach ($filter_desc as $desc)
                    <option value="{{$desc}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="desc" name="desc">
                <option value="" selected>No Description Selected</option>
                @foreach ($filter_desc as $desc)
                <option value="{{$desc}}">{{$desc}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Die Name</h6>
                <input type="text" list="dienames" placeholder="Die Name" name="die" />
                <datalist id="dienames">
                    @foreach ($filter_die as $die)
                    <option value="{{$die}}"></option>
                    @endforeach
                </datalist>
                {{-- <select id="die" name="die">
                <option value="" selected>No Die Name Selected</option>
                @foreach ($filter_die as $die)
                <option value="{{$die}}">{{$die}}</option>
                @endforeach
                </select> --}}
            </div>
            <div class="input-field col s12 l4">
                <h6 class="labelform">Rank</h6>
                <input type="text" list="rankss" placeholder="Rank" name="rank" />
                <datalist id="rankss">
                    <option value="A"></option>
                    <option value="B"></option>
                    <option value="C"></option>
                    <option value="D"></option>
                    <option value="E"></option>
                </datalist>
                {{-- <select id="rank" name="rank">
                <option value="" selected>No Rank Selected</option>
                <option value="A">A</option>
                <option value="B">B</option>
                <option value="C">C</option>
                <option value="D">D</option>
                <option value="E">E</option>
                </select> --}}
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12 l4">
                <h6 class="labelform">Item Status</h6>
                <input type="text" list="statusss" placeholder="Status" name="status" />
                <datalist id="statusss">
                    <option value="1">Active</option>
                    <option value="0">Non-active</option>
                    <option value="2">Slow moving</option>
                </datalist>
                {{-- <select id="status" name="status">
                <option value="" selected>No Item Status Selected</option>
                <option value="1">Active</option>
                <option value="0">Non-active</option>
                <option value="2">Slow moving</option>
                </select> --}}
            </div>
        </div>
        <div class="row">
			<div class="col s12">
                <center>
                    <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                    <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                </center>
			</div>
		</div>
	</form>
</div>
</div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
    <script src="{{asset('js/materialize.min.js')}}"></script>
    <script src="{{asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')}}"></script>
    <script src="{{asset('js/app.js')}}"></script>
    <script src="{{asset('js/app.init.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.js')}}"></script>

    <script src="{{asset('js/custom.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/d3.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/c3.min.js')}}"></script>
    <script src="{{asset('extra-libs/DataTables/jquery.dataTables.min.js')}}"></script>
    {{-- <script src="{{asset('js/pages/datatable/datatable-basic.init.js')}}"></script> --}}
    <script src="{{asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')}}"></script>
    {{-- <script src="{{asset('extra-libs/tiny-editable/mindmup-editabletable.js')}}"></script>
    <script src="{{asset('extra-libs/tiny-editable/numeric-input-example.js')}}"></script> --}}
    <script src="{{asset('libs/sweetalert2/dist/sweetalert2.min.js')}}"></script>
    <script src="{{asset('js/select2/select2.full.min.js')}}"></script>
    {{-- <script src="{{asset('js/select2/select2-custom.js')}}"></script> --}}

    {{-- <script>
        $('.browser-default').select2();
    </script> --}}

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();

    });

    // Sweet Alert for Add SparePart
    $(document).ready(function() {
        $('#add-sparepart').click(function() {
            event.preventDefault();

            var isFormValid = true;
            $('#form input[required]').each(function() {
                if ($(this).val() === '') {
                isFormValid = false;
                return false;
                }
            });

            if(isFormValid){
                var addButton = $(this);
                swal({
                    title: "Are you sure?",
                    text: "Are you sure want to add new spare part?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    closeOnConfirm: false
                    }).then((result) => {
                    if (result.value) {
                        addButton.closest("form").submit();
                    }
                    });
            } else {
                alert("Please fill all required fields before adding a new spare part.");
            }

        });
    });

    // Sweet Alert for Delete Spare Part
    $('.sa-delete').click(function() {
    var deleteButton = $(this);
      swal({
          title: "Are you sure?",
          text: "This spare part will be deleted!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Yes, delete it",
          closeOnConfirm: false
      }).then((result) => {
          if (result.value) {
            var orderId = deleteButton.data('sparepart-id');
            var deleteUrl = "{{ route('delete-sparepart', ['sp_id' => 'TEMP_ID']) }}";
            deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
            window.location.href = deleteUrl;
          }
      });
    });

    </script>

    <script>
        //Hide and Show Drawing Field
        function toggleButtons() {
            var category = document.getElementById('category').value;
            var drawing = document.getElementById('drawing');

            if (category === 'SS') {
                drawing.style.display = 'none';
            } else if (category === 'SK') {
                drawing.style.display = 'inline-block';
            }
        }

        function toggleButtons2() {
            var category2 = document.getElementById('category2').value;
            var drawing2 = document.getElementById('drawing2');

            if (category2 === 'SS') {
                console.log('none');
                drawing2.style.display = 'none';
            } else if (category2 === 'SK') {
                console.log('ada');
                drawing2.style.display = 'inline-block';
            }
        }
    </script>

    <script>
        // Auto Calculate for Opening Amount
        $(document).ready(function () {
            const unitInput = $("#unit");
            const stockInput = $("#stock");
            const amountInput = $("#amount");

            function updateOpeningAmount() {
                const unitPrice = parseFloat(unitInput.val());
                const openingStock = parseFloat(stockInput.val());

                const openingAmount = unitPrice * openingStock;

                amountInput.val(openingAmount.toFixed(2));
            }

            unitInput.on("input", updateOpeningAmount);
            stockInput.on("input", updateOpeningAmount);
        });
    </script>

    <script>
        // Dropdown for add spare part individually or bulky
        function toggleDropdown() {
            var dropdownContent = document.getElementById("dropdown-content");
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        }

        function toggleDropdown2() {
            var dropdownContent = document.getElementById("dropdown-content-download");
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        }

        function selectOption(option) {
            document.getElementById("dropdown-btn").innerHTML = option;
            document.getElementById("dropdown-content").style.display = "none";
        }
    </script>

    <script>
        // Get spare part id from checkbox
        document.addEventListener('DOMContentLoaded', function() {
            var excelOption = document.getElementById('excel-option');

            excelOption.addEventListener('click', function(event) {
                event.preventDefault();

                var checkboxes = document.getElementsByName('check');
                var selectedValues = [];

                for (var i = 0; i < checkboxes.length; i++) {
                    if (checkboxes[i].checked) {
                        selectedValues.push(checkboxes[i].value);
                    }
                }

                var url = '{{ route("multi-sparepart-excel") }}?selectedValues=' + selectedValues.join(',');

                window.location.href = url;
            });
        });

        document.addEventListener("DOMContentLoaded", function () {
            const selectAllCheckbox = document.getElementById("check-all");
            const checkboxes = document.querySelectorAll(".check");

            selectAllCheckbox.addEventListener("click", function () {
                checkboxes.forEach(function (checkbox) {
                    checkbox.checked = selectAllCheckbox.checked;
                });
            });
        });
    </script>

    {{-- <script>
        $("#download").click(function(){
            var postdata = $("#download-form").serialize();
            if ($("#department").val() == ''){
                alert("Please select at least one department to export");
            }else{
                $("#loading-overlay").css("display", "flex");
                $.ajax({
                    url:"{{route('multi-sparepart-excel')}}",
                    type:'POST',
                    data: postdata,
                    success:function(response){
                        $("#loading-overlay").css("display", "none");
                        window.open(response, '_blank');
                    }
                });
            }
        });

    </script> --}}

</body>
</html>

