<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
    <title>HRS - Inventory</title>
    <link href="{{asset('css/icons/customcss.css')}}" rel="stylesheet">
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/email.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
        <link href="{{asset('libs/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet">
        <style>
            .notification-item.hidden {
                display: none;
            }
        </style>

        <!-- Notification Badge (start) -->
        <style>
            .notification-badge {
                position: absolute;
                top: 10px;
                right: 60px;
                background-color: red;
                color: white;
                width: 20px;
                height: 20px;
                border-radius: 50%;
                display: flex;
                justify-content: center;
                align-items: center;
                font-size: 12px;
                font-weight: bold;
                z-index: 1;
            }

            @media screen and (max-width: 768px) {
                .notification-badge {
                    top: 12px;
                    right: 50px;
                    width: 18px;
                    height: 18px;
                }
            }

            .material-icons {
                position: relative;

            }
        </style>
</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="{{route('dashboard')}}" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="{{asset('images/hrs.png')}}" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="{{asset('images/hrs.png')}}" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        @php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($restore != 0)
                        <li><a href="{{route('restore')}}" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        @endif
                        {{-- <li><a href="" class="tooltipped" data-tooltip="Refresh"><i class="material-icons">refresh</i></a></li> --}}


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            @if ($new_notification != 0)
                                <span class="notification-badge">{{ $new_notification }}</span>
                            @endif
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        @foreach ($notification as $notifications)
                                            <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        {{$notifications->notification_title}}
                                                        @if ($notifications->notification_is_read == 0)
                                                            <span class="label label-success m-r-10">New</span>
                                                        @endif
                                                    </h5>
                                                    <span class="mail-desc">{{$notifications->notification_subtitle}}</span> <span class="time">{{date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')}}</span>
                                                </span>
                                            </a>
                                        @endforeach
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="javascript:void(0);"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="{{asset('images/users/2.jpg')}}" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="{{asset('images/users/2.jpg')}}" alt="user"></div>
                                        <div class="u-text">
                                            <h4>{{Auth::user()->name}}</h4>
                                            <p>{{Auth::user()->email}}</p>
                                            {{-- <a class="waves-effect waves-light btn-small red white-text">View Profile</a> --}}
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('profile')}}"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="{{route('reset')}}"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('logout')}}"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> {{--class="side-wrap" --}}
                    <ul class="collapsible">
                        {{-- <li class="small-cap"><span class="hide-menu">PERSONAL</span></li> --}}
                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('supply')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($inventory != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('spare-part')}}"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                         @if ($permission != 0)
                                            {{-- <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In/Out</span></a></li> --}}
                                            <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="{{route('stockout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($budget != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('budgeting')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('department')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($system != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('usercontrol')}}"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('modulesetup')}}"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('itemstatus')}}"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        @endif
                                        {{-- <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Role</span></a></li>
                                        <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Audit Trail</span></a></li> --}}
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('audit')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    </ul>
                </li>
            </ul>
        </aside>

        {{-- <div class="page-wrapper"> --}}
        <div class="page-titles">
            <div class="card">
                <div class="row">
                    <div class="col s12">
                        <div class="card-content">
                        <div class="d-flex align-items-center">
                            <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Notifications</h5>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col s12">
                <div class="card">
                    <div class="card-content">
                        <!-- Search Notification Bar (start) -->
                        <div>
                            <div>
                                <div class="ml-auto">
                                    <div class="input-field m-b-0">
                                        <input placeholder="Search Notification" type="text" id="search-input">
                                    </div>
                                </div>
                            </div>

                        </div><br><br>
                        <!-- Search Notification Bar (end) -->

                        <!-- Action Button (start) -->
                        <div class="grey lighten-5 p-15 d-flex no-block">
                            <label>
                                <input type="checkbox" class="sl-all" /><span>Check All</span></label>
                                <div class="ml-auto">
                                    <a class='font-20 m-l-20 tooltipped markFunction' href='#' style="color: blue; cursor: pointer; font-size: 25px;" data-tooltip="Mark as Read"><i class="material-icons">remove_red_eye</i></a>
                                    <a class='font-20 m-l-20 sa-delete tooltipped' href='#' style="color: blue; cursor: pointer; font-size: 25px;" data-tooltip="Delete"><i class="material-icons deleteFunction">delete_forever</i></a>
                                    <a class='font-20 m-l-10 tooltipped' href='{{route('notification')}}' style="font-size: 23px; color:blue;" data-tooltip="Refresh"><i class="material-icons">refresh</i></a>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col s12" id="scroll2" style="height: 500px;">
                                    <!-- Notification List (start)-->
                                    <div class="table-responsive">
                                        <table class="email-table no-wrap">
                                            <form method="POST" id="notificationForm" action="{{route('delete-notification')}}">
                                                @csrf
                                                <tbody class="list-notification">
                                                    @foreach ($notification as $notifications )
                                                        <tr class="unread notification-item">
                                                            <input type="hidden" class="notification_id" value="{{ $notifications->notification_id}}">
                                                            <input type="hidden" class="notification_is_read" value="{{ $notifications->notification_is_read}}">
                                                            <td class="chb">
                                                                <label>
                                                                    <input type="checkbox" value="{{ $notifications->notification_id}}" id="checkedBox[]" name="checkedBox[]" /><span></span>
                                                                </label>
                                                            </td>
                                                            <td class="user-name">
                                                                @if ($notifications->notification_is_read == 0)
                                                                    <h6 class="m-b-0 notification-title" style="font-weight: bold;">{{ $notifications->notification_title }}</h6>
                                                                @else
                                                                    <h6 class="m-b-0 notification-title">{{ $notifications->notification_title }}</h6>
                                                                @endif
                                                            </td>
                                                            <td class="max-texts">
                                                                {{-- <a href="{{route('notification-detail', $notifications->notification_id)}}"> --}}
                                                                    @if ($notifications->notification_is_read == 0)
                                                                    <span class="label label-success m-r-10">New</span>
                                                                    @endif
                                                                    <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                                    <span class="blue-grey-text text-darken-4 notification-subtitle">{!! $notifications->notification_message !!}</span>
                                                                    </a>
                                                                {{-- </a> --}}
                                                            </td>
                                                            <td class="clip"><i class="fa fa-paperclip"></i></td>
                                                            <td class="time">{{date_format(new Datetime($notifications->notification_datetime), 'd M Y h:i A')}}</td>

                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </form>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>
    </div>

    <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
    <script src="{{asset('js/materialize.min.js')}}"></script>
    <script src="{{asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')}}"></script>
    <script src="{{asset('js/app.js')}}"></script>
    <script src="{{asset('js/app.init.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.js')}}"></script>

    <script src="{{asset('js/custom.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/d3.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/c3.min.js')}}"></script>
    <script src="{{asset('extra-libs/DataTables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('js/pages/datatable/datatable-basic.init.js')}}"></script>
    <script src="{{asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')}}"></script>
    <script src="{{asset('libs/sweetalert2/dist/sweetalert2.min.js')}}"></script>

    <script>$('#zero_config').DataTable();</script>

    <!-- Search Notification (start) -->
    <script>
        const searchInput = document.getElementById('search-input');
        const notificationList = document.querySelector('.list-notification');

        const filterNotification = () => {
            const query = searchInput.value.toLowerCase();
            const notifications = notificationList.querySelectorAll('tr');

            notifications.forEach((notification) => {
                const notificationTitle = notification.querySelector('.m-b-0.notification-title').textContent.toLowerCase();
                const notificationDetail = notification.querySelector('.blue-grey-text.text-darken-4.notification-subtitle').textContent.toLowerCase();
                const notificationDate = notification.querySelector('.time').textContent.toLowerCase();

                if (notificationTitle.includes(query) || notificationDetail.includes(query) || notificationDate.includes(query) )
                {
                    // notification.style.display = 'block';
                    notification.classList.remove('hidden');
                }
                else
                {
                    //notification.style.display = 'none';
                    notification.classList.add('hidden');
                }
            });
        }
        searchInput.addEventListener('input', filterNotification);
    </script>
    <!-- Search Notification (end) -->

    <!-- Select Script (start)-->
    <script>
        $(function() {
            "use strict";

            var mail = $('.email-table .max-texts a');

            // Highlight row when checkbox is checked
            $('.email-table').find('tr > td:first-child').find('input[type=checkbox]').on('change', function() {
                if ($(this).is(':checked')) {
                    $(this).parents('tr').addClass('selected');
                } else {
                    $(this).parents('tr').removeClass('selected');
                }
            });

            // Select All which currently visible
            $(".sl-all").on('click', function() {
                $('.email-table input:checkbox')
                    .not(this)
                    .filter(function() {
                        return $(this).closest('tr').is(':visible');
                    })
                    .prop('checked', this.checked)
                    .parents('tr')
                    .toggleClass('selected', this.checked);
            });

            // Delete Notification Onclick
            $(".material-icons.deleteFunction").on('click', function() {
                swal({
                    title: "Are you sure?",
                    text: "This will delete all the selected notifications!",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes, delete it",
                    closeOnConfirm: false

                }).then((result) => {
                    if (result.value) {

                        var form = document.getElementById('notificationForm');
                        form.action = "{{route('delete-notification')}}" ;
                        form.submit();
                    }
                });
            });

            // Mark as read
            $(".markFunction").on('click', function() {
                swal({
                    title: "Are you sure?",
                    text: "This will marked the selected notifications as read",
                    type: "question",
                    showCancelButton: true,
                    confirmButtonColor: "#4682B4",
                    confirmButtonText: "Yes, mark it as read",
                    closeOnConfirm: false

                }).then((result) => {

                    var form = document.getElementById('notificationForm');
                    form.action = "{{route('markRead-notification')}}" ;
                    form.submit();
                });
            });

            // Select All
            $(".allNotiFunction").on('click', function() {
                const notificationList = document.querySelector('.list-notification');

                const notifications = notificationList.querySelectorAll('tr');

                notifications.forEach((notification) => {
                    notification.classList.remove('hidden');
                });
            });

            // Select Read
            $(".readFunction").on('click', function() {
                const notificationList = document.querySelector('.list-notification');

                const notifications = notificationList.querySelectorAll('tr');

                notifications.forEach((notification) => {
                    const notificationRead = notification.querySelector('.notification_is_read').value;
                    if (notificationRead == 1)
                    {
                        // notification.style.display = 'block';
                        notification.classList.remove('hidden');
                    }
                    else
                    {
                        //notification.style.display = 'none';
                        notification.classList.add('hidden');
                    }
                });
            });

            // Select Unread
            $(".unreadFunction").on('click', function() {
                const notificationList = document.querySelector('.list-notification');

                const notifications = notificationList.querySelectorAll('tr');

                notifications.forEach((notification) => {
                    const notificationRead = notification.querySelector('.notification_is_read').value;
                    if (notificationRead == 0)
                    {
                        // notification.style.display = 'block';
                        notification.classList.remove('hidden');
                    }
                    else
                    {
                        //notification.style.display = 'none';
                        notification.classList.add('hidden');
                    }
                });
            });


            $(".dropdown-trigger").dropdown({
                constrainWidth: false,
                alignment: 'left',
            });

            $(".show-left-panel").on('click', function() {
                $('.left-part').toggleClass('show-panel');
                $('.show-left-panel').toggleClass('ti-menu');
            });

            $("#compose_mail").on("click", function() {
                $('.right-part.mail-list').fadeOut("fast");
                $('.right-part.mail-details').fadeOut("fast");
                $('.right-part.mail-compose').fadeIn("fast");
            });

            $("#cancel_compose").on("click", function() {
                $('.right-part.mail-compose').fadeOut("fast");
                $('.right-part.mail-list').fadeIn("fast");
            });

            $(mail).on("click", function() {
                $('.right-part.mail-list').fadeOut("fast");
                $('.right-part.mail-details').fadeIn("fast");
            });

            $("#back_to_inbox").on("click", function() {
                $('.right-part.mail-details').fadeOut("fast");
                $('.right-part.mail-list').fadeIn("fast");
            });

        });
    </script>
    <!-- Select Script (start)-->

    <script type="text/javascript">
        $('#scroll2').perfectScrollbar();
    </script>


</body>
</html>

