<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
    <title>HRS - Inventory</title>
    <link href="{{asset('extra-libs/c3/c3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
    <link href="{{asset('libs/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="{{route('dashboard')}}" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="{{asset('images/hrs.png')}}" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="{{asset('images/hrs.png')}}" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        @php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($restore != 0)
                        <li><a href="{{route('restore')}}" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        @endif
                        {{-- <li><a href="" class="tooltipped" data-tooltip="Refresh"><i class="material-icons">refresh</i></a></li> --}}


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            @if ($new_notification != 0)
                                <span class="notification-badge">{{ $new_notification }}</span>
                            @endif
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        @foreach ($notification as $notifications)
                                            <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        {{$notifications->notification_title}}
                                                        @if ($notifications->notification_is_read == 0)
                                                            <span class="label label-success m-r-10">New</span>
                                                        @endif
                                                    </h5>
                                                    <span class="mail-desc">{{$notifications->notification_subtitle}}</span> <span class="time">{{date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')}}</span>
                                                </span>
                                            </a>
                                        @endforeach
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="{{route('notification')}}"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="{{asset('images/users/2.jpg')}}" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="{{asset('images/users/2.jpg')}}" alt="user"></div>
                                        <div class="u-text">
                                            <h4>{{Auth::user()->name}}</h4>
                                            <p>{{Auth::user()->email}}</p>
                                            {{-- <a class="waves-effect waves-light btn-small red white-text">View Profile</a> --}}
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('profile')}}"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="{{route('reset')}}"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('logout')}}"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> {{--class="side-wrap" --}}
                    <ul class="collapsible">
                        {{-- <li class="small-cap"><span class="hide-menu">PERSONAL</span></li> --}}
                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('supply')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($inventory != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('spare-part')}}"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                         @if ($permission != 0)
                                            {{-- <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In/Out</span></a></li> --}}
                                            <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="{{route('stockout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($budget != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('budgeting')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('department')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($system != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('usercontrol')}}"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('modulesetup')}}"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('itemstatus')}}"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        @endif
                                        {{-- <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Role</span></a></li>
                                        <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Audit Trail</span></a></li> --}}
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('audit')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    </ul>
                </li>
            </ul>
        </aside>

        {{-- <div class="page-wrapper"> --}}
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Edit Budget</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    <div class="table-responsive">

                                        <form method="POST" id="edit-budget" action="{{route('update-budget', $budgeting->budget_id)}}">
                                            @csrf
                                            @method('PUT')
                                            <div class="row">
                                                <div class="input-field col s12 l6">
                                                    <h6 class="labelform">Department</h6>
                                                    <select id="department" name="department" required>
                                                        @if(old('department', $budgeting->department_id))
                                                            <option value="{{$budgeting->department_id}}" selected>{{$budgeting->department_name}}</option>
                                                        @endif
                                                        @foreach ($department as $departments)
                                                        <option value="{{$departments->department_id}}">{{$departments->department_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="input-field col s12 l6">
                                                    <h6 class="labelform">Budget (RM)</h6>
                                                    <input id="budget" name="budget" type="number" value="{{$budgeting->budget_budget}}" required>
                                                </div>
                                                <div class="input-field col s12 l6">
                                                    <h6 class="labelform">Month</h6>
                                                    <input id="month" name="month" type="month" value="{{$budgeting->budget_month}}" required>
                                                </div>
                                            </div>
                                            <br><br>
                                                <div class="row">
                                                    <div class="col s6">
                                                        <center>
                                                            <a href="{{route('budgeting')}}" class="btncancel waves-red waves-effect">Cancel</a><br><br>
                                                        </center>
                                                    </div>
                                                    <div class="col s6">
                                                        <center>
                                                            <button type="submit" class="btnpaynow waves-effect waves-light" name="action">Update</button>&nbsp;&nbsp;
                                                        </center>
                                                    </div>
                                                </div>
                                            </form>

                                    </div>
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        {{-- </div> --}}


        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
    <script src="{{asset('js/materialize.min.js')}}"></script>
    <script src="{{asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')}}"></script>
    <script src="{{asset('js/app.js')}}"></script>
    <script src="{{asset('js/app.init.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.js')}}"></script>

    <script src="{{asset('js/custom.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/d3.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/c3.min.js')}}"></script>
    <script src="{{asset('extra-libs/DataTables/jquery.dataTables.min.js')}}"></script>
    {{-- <script src="{{asset('js/pages/datatable/datatable-basic.init.js')}}"></script> --}}
    <script src="{{asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')}}"></script>
    {{-- <script src="{{asset('extra-libs/tiny-editable/mindmup-editabletable.js')}}"></script>
    <script src="{{asset('extra-libs/tiny-editable/numeric-input-example.js')}}"></script> --}}
    <script src="{{asset('libs/sweetalert2/dist/sweetalert2.min.js')}}"></script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(document).ready(function() {
    $('#edit-budget').submit(function(event) {

      // Check if all required inputs are filled
      var isFormValid = true;
      $('#edit-budget input[required]').each(function() {
        if ($(this).val() === '') {
          isFormValid = false;
          return false; // Exit the loop if an empty required input is found
        }
      });

      if (isFormValid) {
        swal({
          title: "Update Success!",
          text: "",
          type: "success",
          showConfirmButton: false
        });
      }
    });
  });

  </script>


</body>
</html>

