{{-- <!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
        <title>HRS - Inventory</title>
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/error-pages.css')}}" rel="stylesheet">
    </head>

    <body>
        <section id="wrapper" class="error-page">
            <div class="error-box" style="background:url({{asset('images/big/auth-bg.jpg')}}) no-repeat center center;">
                <div class="error-body center-align">
                    <div class="card" style="width: 30%;margin: 0 auto;">
                        <div class="card-content">
                            <img src="{{asset('images/logo-icon.png')}}" alt="image">
                            <h6>Reset Your Password</h6>
                            <form action="index.html">
                                <div class="input-field">
                                    <input type="text" name="name_your" placeholder="New Password" required="">
                                </div>
                                <div class="input-field">
                                    <input type="email" name="email_your" placeholder="Confirm New Password" required="">
                                </div>
                                <button class="waves-effect waves-light btn indigo">Reset</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
        <script src="{{asset('js/materialize.min.js')}}"></script>

    </body>
</html> --}}

<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
        <title>HRS - Inventory</title>
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/authentication.css')}}" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <!-- Preloader -->
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url({{asset('images/big/auth-bg.jpg')}}) no-repeat center center;">
                <div class="auth-box">
                    <!-- Forgot Password -->
                    <div id="">
                        <div class="logo">
                            {{-- <span class="db"><img src="{{asset('images/hrs.png')}} " alt="logo" /></span> --}}
                            <h5 class="font-medium m-b-20">Reset Password</h5>
                            <span>Please enter your last 4 digit IC number</span>
                        </div>
                        <div class="row">
                            <form class="col s12" action="{{route('reset-pass')}}" method="GET">
                                <div class="row">
                                    <div class="input-field col s12">
                                        <input id="email1" type="number" class="validate" name="ic_no" placeholder="Last 4 digit IC number" required autofocus>
                                    </div>
                                </div>

                                 <!-- Error message -->
                                 @if ($errors->any())
                                 <div class="alert alert-danger">
                                     <center><ul>
                                         @foreach ($errors->all() as $error)
                                             <li class="red-text">We can't find any last 4 digit IC number</li>
                                         @endforeach
                                     </ul></center>
                                 </div>
                                 @endif

                                <div class="row m-t-20">
                                    <div class="col s12">
                                        <center>
                                            <button type="submit" class="btn-large w100 red" name="action">Submit</button><p></p>
                                            <a href="{{route('supply')}}" class="link">Back</a>
                                        </center>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
        <script>
        $(function() {
        $(".preloader").fadeOut();
        });
        </script>
    </body>
</html>
