<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
        <title>HRS - Inventory</title>
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/authentication.css')}}" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url({{asset('images/big/auth-bg2.jpg')}}) no-repeat left center;">
                <div class="container">
                    <div class="row">
                        <div class="col s12 l8 m6 demo-text">
                            <img src="{{asset('images/hrs.png')}}" alt="logo" width="17%" />
                            <h1 class="font-light m-t-40"><span class="font-medium black-text">Inventory Management System</span></h1>
                            {{-- <p>This is just a demo text which you can change as per your requeirment, so change once you get chance. this is default text.</p>
                            <a class="btn btn-round red m-t-5">Know more</a> --}}
                        </div>
                    </div>
                    <div class="auth-box auth-sidebar">
                        <div id="loginform">
                            <div class="p-l-10">
                                <h5 class="font-medium m-b-0 m-t-40">Register</h5>
                                <small>Create your account</small>
                            </div>

                            <!-- Form -->
                            <div class="row">
                                <form class="col s12" action="index.html">

                                    <!-- email -->
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="name" type="text" class="validate" required>
                                            <label for="name">Name</label>
                                        </div>
                                    </div>

                                    <!-- email -->
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="email" type="email" class="validate" required>
                                            <label for="email">Email</label>
                                        </div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="password" type="password" class="validate" required>
                                            <label for="password">Password</label>
                                        </div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="cpassword" type="password" class="validate" required>
                                            <label for="cpassword">Password</label>
                                        </div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row m-t-5">
                                        <div class="col s7">
                                            <label>
                                                <input type="checkbox" />
                                                <span>Agree to all Terms</span>
                                            </label>
                                        </div>
                                    </div>

                                    <!-- pwd -->
                                    <div class="row m-t-40">
                                        <div class="col s12">
                                            <button class="btn-large w100 red" type="submit">Sign Up</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div class="center-align m-t-20 db">
                                Already have an account? <a href="authentication-login2.html">Sign in!</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
        <script src="{{asset('js/materialize.min.js')}}"></script>

        <script>
        $(function() {
        $(".preloader").fadeOut();
        });
        </script>
    </body>
</html>
