<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
        <title>HRS - Inventory</title>
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/authentication.css')}}" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <!-- Preloader -->
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url({{asset('images/big/auth-bg.jpg')}}) no-repeat center center;">
                <div class="auth-box">
                    <!-- Forgot Password -->
                    <div id="">
                        <div class="logo">
                            {{-- <span class="db"><img src="{{asset('images/hrs.png')}} " alt="logo" /></span> --}}
                            <h5 class="font-medium m-b-20">Reset Your Password</h5>
                            {{-- <span>Please enter your last 4 digit IC number</span> --}}
                        </div>
                        <div class="row">
                            <form class="col s12" action="{{route('new-pass', $id)}}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="input-field col s12 l11">
                                        <h6>New Password</h6>
                                        <input type="password" class="validate" id="password" name="new_pass" placeholder="Enter a new password" required>
                                    </div>
                                    <div class="input-field col s12 l1 bottom">
                                        <br><br>
                                        <i class="fas fa-eye-slash" id="toggle-password"></i>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="input-field col s12 l11">
                                        <h6>Confirm New Password</h6>
                                        <input type="password" class="validate" id="password2" name="confirm_pass" placeholder="Confirm your new password" required>
                                    </div>
                                    <div class="input-field col s12 l1 bottom">
                                        <br><br>
                                        <i class="fas fa-eye-slash" id="toggle-password2"></i>
                                    </div>
                                </div>

                                 <!-- Error message -->
                                 @if ($errors->any())
                                 <div class="alert alert-danger">
                                     <center><ul>
                                         @foreach ($errors->all() as $error)
                                             <li class="red-text">The password didnt match</li>
                                         @endforeach
                                     </ul></center>
                                 </div>
                                 @endif

                                <div class="row m-t-20">
                                    <div class="col s12">
                                        <center>
                                            <button type="submit" class="btn-large w100 red" name="action">Reset Password</button><p></p>
                                        </center>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
        <script>
            $(function() {
            $(".preloader").fadeOut();
            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const passwordInput = document.getElementById('password');
                const passwordInput2 = document.getElementById('password2');
                const togglePasswordIcon = document.getElementById('toggle-password');
                const togglePasswordIcon2 = document.getElementById('toggle-password2');

                togglePasswordIcon.addEventListener('click', function() {
                    if (passwordInput.type === 'password') {
                        passwordInput.type = 'text';
                        togglePasswordIcon.classList.remove('fa-eye-slash');
                        togglePasswordIcon.classList.add('fa-eye');
                    } else {
                        passwordInput.type = 'password';
                        togglePasswordIcon.classList.remove('fa-eye');
                        togglePasswordIcon.classList.add('fa-eye-slash');
                    }
                });

                togglePasswordIcon2.addEventListener('click', function() {
                    if (passwordInput2.type === 'password') {
                        passwordInput2.type = 'text';
                        togglePasswordIcon2.classList.remove('fa-eye-slash');
                        togglePasswordIcon2.classList.add('fa-eye');
                    } else {
                        passwordInput2.type = 'password';
                        togglePasswordIcon2.classList.remove('fa-eye');
                        togglePasswordIcon2.classList.add('fa-eye-slash');
                    }
                });
            });
        </script>
    </body>
</html>
