<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
        <title>HRS - Inventory</title>
        <link href="{{asset('css/style.css')}}" rel="stylesheet">
        <link href="{{asset('css/pages/authentication.css')}}" rel="stylesheet">
    </head>

    <body>
        <div class="main-wrapper">
            <!-- Preloader -->
            <div class="preloader">
                <div class="loader">
                    <div class="loader__figure"></div>
                    <p class="loader__label">HRS</p>
                </div>
            </div>

            <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url({{asset('images/big/auth-bg.jpg')}}) no-repeat center center;">
                <div class="auth-box">
                    <!-- Forgot Password -->
                    <div id="">
                        <div class="logo">
                            <img src="{{asset('images/hrs.png')}}" alt="logo" width="17%" />
                            <h5 class="font-medium m-b-20">Recover Password</h5>
                            <span>Enter your email and instructions will be sent to you!</span>
                        </div>
                        <div class="row">
                            <!-- Form -->
                            <form class="col s12" method="POST" action="">
                                @csrf
                                <!-- email -->
                                <div class="row">
                                    <div class="input-field col s12">
                                        <input id="email1" type="email" class="validate" name="email" placeholder="Email"
                                        value="" required autofocus>
                                    </div>
                                </div>

                                <!-- Error message -->
                                @if ($errors->any())
                                <div class="alert alert-danger">
                                    <center><ul>
                                        @foreach ($errors->all() as $error)
                                            <li class="red-text">{{ $error }} </li>
                                        @endforeach
                                    </ul></center>
                                </div>
                                @endif

                                <!-- Success Reset Password -->
                                @if (session()->has('status'))
                                    <div class="alert alert-success">
                                        <center><span class="green-text">
                                            {{ session()->get('status') }}
                                        </span></center>
                                    </div>
                                @endif
                                <div class="row m-t-20">
                                    <div class="col s12">
                                        <center>
                                            <a href="" ><button class="btn-large w100 red" type="submit" name="action">Send Password Link</button></a><p></p>
                                            <a href="{{route('auth.login')}}" class="link">Back to Login</a>
                                        </center>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
        <script>
        $(function() {
        $(".preloader").fadeOut();
        });
        </script>
    </body>
</html>
