<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/hrs.ico')}}">
    <title>HRS - Inventory</title>
    <link href="{{asset('extra-libs/c3/c3.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <link href="{{asset('css/pages/data-table.css')}}" rel="stylesheet">
    <link href="{{asset('libs/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet" type="text/css">

    <style>
        .notification-badge {
            position: absolute;
            top: 10px;
            right: 60px;
            background-color: red;
            color: white;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 12px;
            font-weight: bold;
            z-index: 1;
        }

        @media screen and (max-width: 768px) {
            .notification-badge {
                top: 12px;
                right: 50px;
                width: 18px;
                height: 18px;
            }
        }

        .material-icons {
            position: relative;

        }

        .scrollable-container {
            width: 100%;
            overflow: auto;
        }

        .desktop-logo {
            display: inline-block;
        }
        .mobile-logo {
            display: none;
        }

        @media (max-width: 768px) {
            .desktop-logo {
                display: none;
            }
            .mobile-logo {
                display: inline-block;
            }
        }
    </style>

</head>

<body>
    <div class="main-wrapper" id="main-wrapper">
        <div class="preloader">
            <div class="loader">
                <div class="loader__figure"></div>
                <p class="loader__label">HRS</p>
            </div>
        </div>

        <header class="topbar">
            <nav>
                <div class="nav-wrapper">
                    <a href="{{route('dashboard')}}" class="brand-logo">
                        <span class="icon">
                            <img class="desktop-logo" src="{{asset('images/hrs.png')}}" width="36%" style="margin-top: 16px;">
                            <img class="mobile-logo" src="{{asset('images/hrs.png')}}" width="10%" style="margin-top: 16px;">
                        </span>
                    </a>

                    <ul class="">
                        <li class="hide-on-med-and-down">
                            <a href="javascript: void(0);" class="nav-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                        <li class="hide-on-large-only">
                            <a href="javascript: void(0);" class="sidebar-toggle">
                                <span class="bars bar1"></span>
                                <span class="bars bar2"></span>
                                <span class="bars bar3"></span>
                            </a>
                        </li>
                    </ul>

                    <ul class="right">
                        @php
                            $restore = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Restore')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($restore != 0)
                        <li><a href="{{route('restore')}}" class="tooltipped" data-tooltip="Restore"><i class="material-icons">restore_page</i></a></li>
                        @endif
                        {{-- <li><a href="" class="tooltipped" data-tooltip="Refresh"><i class="material-icons">refresh</i></a></li> --}}


                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="noti_dropdown">
                            @if ($new_notification != 0)
                                <span class="notification-badge">{{ $new_notification }}</span>
                            @endif
                            <i class="material-icons">notifications</i></a>
                            <ul id="noti_dropdown" class="mailbox dropdown-content">
                                <li>
                                    <div class="drop-title">Notifications</div>
                                </li>
                                <li>
                                    <div class="message-center">
                                        <!-- Message -->
                                        @foreach ($notification as $notifications)
                                            <a href="{{route('click-notification', $notifications->notification_id)}}">
                                                <span class="btn-floating btn-large red"><i class="material-icons">priority_high</i></span>
                                                <span class="mail-contnet">
                                                    <h5>
                                                        {{$notifications->notification_title}}
                                                        @if ($notifications->notification_is_read == 0)
                                                            <span class="label label-success m-r-10">New</span>
                                                        @endif
                                                    </h5>
                                                    <span class="mail-desc">{{$notifications->notification_subtitle}}</span> <span class="time">{{date_format(new DateTime($notifications->notification_datetime), 'd/m/Y h:i A')}}</span>
                                                </span>
                                            </a>
                                        @endforeach
                                    </div>
                                </li>
                                <li>
                                    <a class="center-align" href="{{route('notification')}}"> <strong>Check all notifications</strong> </a>
                                </li>
                            </ul>
                        </li>

                        <li><a class="dropdown-trigger" href="javascript: void(0);" data-target="user_dropdown"><img src="{{asset('images/users/2.jpg')}}" alt="user" class="circle profile-pic"></a>
                            <ul id="user_dropdown" class="mailbox dropdown-content dropdown-user">
                                <li>
                                    <div class="dw-user-box">
                                        <div class="u-img"><img src="{{asset('images/users/2.jpg')}}" alt="user"></div>
                                        <div class="u-text">
                                            <h4>{{Auth::user()->name}}</h4>
                                            <p>{{Auth::user()->email}}</p>
                                            {{-- <a class="waves-effect waves-light btn-small red white-text">View Profile</a> --}}
                                        </div>
                                    </div>
                                </li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('profile')}}"><i class="material-icons">account_circle</i> My Profile</a></li>
                                <li><a href="{{route('reset')}}"><i class="material-icons">settings</i> Reset Password</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="{{route('logout')}}"><i class="material-icons">power_settings_new</i> Logout</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="left-sidebar">
            <ul id="slide-out" class="sidenav">
                 <li> {{--class="side-wrap" --}}
                    <ul class="collapsible">
                        {{-- <li class="small-cap"><span class="hide-menu">PERSONAL</span></li> --}}
                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Supply Management')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">widgets</i><span class="hide-menu"> Supply Management</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('supply')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Supply Management</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $inventory = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Spare Part','Stock In/Out'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($inventory != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">move_to_inbox</i><span class="hide-menu"> Inventory Tracking </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Spare Part')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('spare-part')}}"><i class="material-icons">adjust</i><span class="hide-menu">Spare Part</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Stock In/Out')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                         @if ($permission != 0)
                                            {{-- <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In/Out</span></a></li> --}}
                                            <li><a href="{{route('stockinout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock In History</span></a></li>
                                            <li><a href="{{route('stockout')}}"><i class="material-icons">adjust</i><span class="hide-menu">Stock Out History</span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $budget = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['Budgeting','Department'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($budget != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">attach_money</i><span class="hide-menu"> Budgeting</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Budgeting')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('budgeting')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Budgeting </span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Department')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('department')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Department </span></a></li>
                                        @endif
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $system = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->whereIn('up_module', ['User Access Control','Module Page Setup','Item Status'])
                                        ->where('is_view', 1)
                                        ->where('id', Auth::user()->id)
                                        ->count();
                        @endphp
                        @if ($system != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow two-column"><i class="material-icons">desktop_mac</i><span class="hide-menu"> System Management </span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'User Access Control')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('usercontrol')}}"><i class="material-icons">adjust</i><span class="hide-menu">User Access Control</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Module Page Setup')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('modulesetup')}}"><i class="material-icons">adjust</i><span class="hide-menu">Module Page Setup</span></a></li>
                                        @endif

                                        @php
                                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                        ->where('up_module', 'Item Status')
                                                        ->where('id', Auth::user()->id)
                                                        ->value('is_view');
                                        @endphp
                                        @if ($permission != 0)
                                            <li><a href="{{route('itemstatus')}}"><i class="material-icons">adjust</i><span class="hide-menu">Item Status</span></a></li>
                                        @endif
                                        {{-- <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Role</span></a></li>
                                        <li><a href="app-support-ticket.html"><i class="material-icons">contact_mail</i><span class="hide-menu">Audit Trail</span></a></li> --}}
                                    </ul>
                                </div>
                            </li>
                        @endif

                        @php
                            $permission = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                        ->where('up_module', 'Audit Trail')
                                        ->where('id', Auth::user()->id)
                                        ->value('is_view');
                        @endphp
                        @if ($permission != 0)
                            <li>
                                <a href="javascript: void(0);" class="collapsible-header has-arrow"><i class="material-icons">date_range</i><span class="hide-menu"> Audit Trail</span></a>
                                <div class="collapsible-body">
                                    <ul>
                                        <li><a href="{{route('audit')}}"><i class="material-icons">adjust</i><span class="hide-menu"> Audit Trail</span></a></li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    </ul>
                </li>
            </ul>
        </aside>

        {{-- <div class="page-wrapper"> --}}
            <div class="page-titles">
                <div class="card">
                    <div class="row">
                        <div class="col s12">
                            <div class="card-content">
                            <div class="d-flex align-items-center">
                                <i class="small material-icons">settings</i>&nbsp;&nbsp;<h5 class="font-medium m-b-0">Audit Trail</h5>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid">
              <div class="row">
                  <div class="col s12">
                      <div class="card">
                        <div class="row">
                            <div class="col s12">
                                <div class="card-content">
                                    <div class="table-responsive">
                                        @php
                                            $create = DB::table('users')->join('user_permission', 'up_role_id','=','user_role_id')
                                                                    ->where('up_module', 'Audit Trail')
                                                                    ->where('id', Auth::user()->id)
                                                                    ->value('is_create');
                                        @endphp
                                        <div class="dropdown2 right">
                                            <a href="#modal1" class="waves-effect waves-light btn indigo right modal-trigger">Filter</a>
                                        </div><br>

                                        @if(session('error'))
                                            <script>
                                                alert('Please make a selection of the dataset for data generation within PDF.', 'TEST');
                                            </script>
                                        @endif

                                        {{-- <div class="row">
                                            <div class="input-field col s12 l3">
                                            </div>
                                            <div class="input-field col s12 l2">
                                                <h6 class="labelform">From</h6>
                                                <input type="date" name="from" id="fromDate">
                                            </div>
                                            <div class="input-field col s12 l1 ">
                                            </div>
                                            <div class="input-field col s12 l2">
                                                <h6 class="labelform">To</h6>
                                               <input type="date" name="to" id="toDate">
                                            </div>
                                        </div> --}}

                                        <table class="table striped m-b-20" id="editable-datatable">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Activity</th>
                                                    <th>Description</th>
                                                    <th>User</th>
                                                    <th>Date & Time</th>
                                                    <th class="center">Action</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                    $no = 1;
                                                @endphp
                                                @foreach ($audit as $audits)
                                                <tr id="1" class="gradeX">
                                                    <td>{{$no}}</td>
                                                    <td>{{$audits->at_activity}}</td>
                                                    <td>
                                                        @if ($audits->at_activity == 'Add Spare Part by Group')
                                                            Added Spare Parts by Group in excel
                                                        @elseif ($audits->at_activity == 'Add Supplier by Group')
                                                            Add Suppliers by Group in excel
                                                        @else
                                                            {!!$audits->at_description!!}
                                                        @endif
                                                    </td>
                                                    <td>{{$audits->name}} </td>
                                                    <td>{{date_format(new DateTime($audits->created_at), 'd/m/Y H:i a')}}</td>
                                                    <td class="center">
                                                        <a href="{{route('audit-single-pdf',$audits->at_id)}}"><span class="label label-blue tooltipped" data-tooltip="Download"><i class="fas fa-download" ></i></span></a>&nbsp;&nbsp;
                                                        <label>
                                                            <input type="checkbox" name="check" id="check" value="{{$audits->at_id}}">
                                                            <span></span>
                                                        </label>
                                                    </td>
                                                </tr>
                                                @php
                                                    $no++;
                                                @endphp
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <a class='dropdown-trigger waves-effect waves-light btn indigo right' href='#' data-target='dropdown1'>Download</a>
                                        <ul id='dropdown1' class='dropdown-content'>
                                            <li><a href="{{route('audit-all-pdf')}}">All</a></li>
                                            <li class="divider"></li>
                                            <li><a href="#" id="selected">Selected</a></li>
                                        </ul>
                                    <br><br>
                                </div>
                            </div>
                          </div>
                      </div>
                  </div>
                </div>
            </div>
        {{-- </div> --}}

    <!-- Modal Filter Data -->
    <div id="modal1" class="modal modal-fixed-footer">
        <div class="modal-content">
        <h4 class="modalheader">Filter Audit Trail</h4>
        <form method="GET" action="{{route('audit')}}" enctype="multipart/form-data">
            <div class="row">
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Activity</h6>
                    <select id="activity" name="activity[]" multiple="multiple" style="width: 100%;">
                        <option value="">No Activity Selected</option>
                    @foreach ($filter_activity as $activity)
                    <option value="{{$activity}}">{{$activity}}</option>
                    @endforeach
                    </select>
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">Description</h6>
                    <input id="description" name="description" type="text">
                </div>
                <div class="input-field col s12 l4">
                    <h6 class="labelform">User</h6>
                    <select id="user" name="user">
                    <option value="" selected>No User Selected</option>
                    @foreach ($user as $users)
                    <option value="{{$users->id}}">{{$users->name}}</option>
                    @endforeach
                    </select>
                </div>
                <div class="input-field col s12 l6">
                    <h6 class="labelform">From</h6>
                    <input type="date" name="from">
                </div>
                <div class="input-field col s12 l6">
                    <h6 class="labelform">To</h6>
                    <input type="date" name="to">
                </div>
                <div class="input-field col s12">
                    {{-- <button type="submit" class="waves-effect waves-light btn indigo right modal-trigger">Submit</button> --}}
                    <div class="col s12">
                        <center>
                            <button type="submit" class="waves-effect waves-light btn indigo right">Apply</button>&nbsp;&nbsp;
                            <button type="submit" class="waves-effect waves-light btn indigo left">Clear Filter</button>&nbsp;&nbsp;
                        </center>
                    </div>
                </div>
            </div>
        </form>
    </div>
    </div>

        <footer class="center-align m-b-30 m-l-15 m-r-15">All Rights Reserved by MatPress. Designed and Developed by <a href="https://tamarix.com.my/">Tamarix Onesolution</a>.</footer>

    </div>

    <script src="{{asset('libs/jquery/dist/jquery.min.js')}}"></script>
    <script src="{{asset('js/materialize.min.js')}}"></script>
    <script src="{{asset('libs/perfect-scrollbar/dist/js/perfect-scrollbar.jquery.min.js')}}"></script>
    <script src="{{asset('js/app.js')}}"></script>
    <script src="{{asset('js/app.init.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.horizontal.js')}}"></script>
    <script src="{{asset('js/app-style-switcher.js')}}"></script>

    <script src="{{asset('js/custom.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/d3.min.js')}}"></script>
    <script src="{{asset('extra-libs/c3/c3.min.js')}}"></script>
    <script src="{{asset('extra-libs/DataTables/jquery.dataTables.min.js')}}"></script>
    {{-- <script src="{{asset('js/pages/datatable/datatable-basic.init.js')}}"></script> --}}
    <script src="{{asset('extra-libs/jquery-datatables-editable/jquery.dataTables.js')}}"></script>
    {{-- <script src="{{asset('extra-libs/tiny-editable/mindmup-editabletable.js')}}"></script>
    <script src="{{asset('extra-libs/tiny-editable/numeric-input-example.js')}}"></script> --}}
    <script src="{{asset('libs/sweetalert2/dist/sweetalert2.min.js')}}"></script>

    <script>
    // $('#mainTable').editableTableWidget().numericInputExample().find('td:first').focus();
    // $('#editable-datatable').editableTableWidget().numericInputExample().find('td:first').focus();

    $(function() {

        $('#editable-datatable').DataTable();

    });

    $('#add-supplier').click(function() {
        var deleteButton = $(this); // Store the reference to the delete button
        swal({
            title: "Are you sure?",
            text: "Are you sure want to add new supplier?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes",
            closeOnConfirm: false
        }).then((result) => {
            if (result.value) {
                var orderId = deleteButton.data('reject-id'); // Access the addressId using the stored reference
                var deleteUrl = "";
                deleteUrl = deleteUrl.replace('TEMP_ID', orderId);
                window.location.href = deleteUrl;
            }
        });
    });

    </script>

    <script>
        // Get spare part id from checkbox
        document.addEventListener('DOMContentLoaded', function() {
            var excelOption = document.getElementById('selected');

            excelOption.addEventListener('click', function(event) {
                // Prevent the default link behavior
                event.preventDefault();

                var checkboxes = document.getElementsByName('check');
                var selectedValues = [];

                for (var i = 0; i < checkboxes.length; i++) {
                    if (checkboxes[i].checked) {
                        selectedValues.push(checkboxes[i].value);
                    }
                }

                // Construct the URL with selectedValues as query parameters
                var url = '{{ route("audit-multi-pdf") }}?selectedValues=' + selectedValues.join(',');

                // Redirect to the download URL
                window.location.href = url;
            });
        });
    </script>

    {{-- <script>
        function filterTable() {
            // Get the input values
            var fromDate = document.getElementById("fromDate").value;
            var toDate = document.getElementById("toDate").value;

            // Loop through each table row
            var table = document.getElementById("editable-datatable");
            var rows = table.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                var row = rows[i];
                var dateCell = row.getElementsByTagName("td")[3]; // Change index to match your date column
                console.log(dateCell);

                if (dateCell) {
                    var dateValue = dateCell.innerText;

                    // Check if the date is within the selected range
                    if (fromDate <= dateValue && dateValue >= toDate) {
                        row.style.display = "";
                    } else {
                        row.style.display = "none";
                    }
                }
            }
        }

        // Attach an event listener to the date inputs to trigger the filtering
        document.getElementById("fromDate").addEventListener("change", filterTable);
        document.getElementById("toDate").addEventListener("change", filterTable);
    </script> --}}


</body>
</html>

