<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockInOut extends Model
{
    use HasFactory;

    protected $primaryKey = 'si_id';
    protected $table = 'stock_inout';
    protected $fillable = [
        'si_sp_id',
        'si_type',
        'si_quantity',
        'si_unitprice',
        'si_total',
        'si_itemlotno',
        'si_attachment',
        'si_who',
        'is_deleted',
        'updated_at'
    ];

    public function sparePart()
    {
        return $this->belongsTo(SparePart::class, 'si_sp_id', 'sp_id');
    }
}
