<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SparePart extends Model
{
    use HasFactory;

    protected $primaryKey = 'sp_id';
    protected $table = 'spare_part';
    protected $fillable = [
        'sp_supplier_id',
        'sp_category',
        'sp_series',
        'sp_itemno',
        'sp_line',
        'sp_location',
        'sp_department',
        'sp_unitprice',
        'sp_opening_stock',
        'sp_opening_amount',
        'sp_min_stock',
        'sp_desc',
        'sp_die_name',
        'sp_rank',
        'sp_status',
        'sp_drawing',
        'is_deleted',
        'is_duplicate',
        'updated_at'
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'sp_supplier_id', 'supplier_id');
    }

    public function stockInOut()
    {
        return $this->hasMany(StockInOut::class, 'si_sp_id', 'sp_id')
                    ->where('is_deleted', 0)
                    ->where('si_type', 'Stock In');
    }
}
