<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LowStock extends Mailable
{
    use Queueable, SerializesModels;

    public $series;
    public $item_number;
    public $category;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($series, $item_number, $category)
    {
        $this->series = $series;
        $this->item_number = $item_number;
        $this->category = $category;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.low-stock');
    }
}
