<?php

namespace App\Http\Controllers;

use App\Models\Budgetting;
use App\Models\Department;
use App\Models\Notifications;
use App\Models\SparePart;
use App\Models\StockInOut;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function showDashboard()
    {
        if(Auth::check()){
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();
            $supply_count = Supplier::where('is_deleted', 0)->count();
            $department = Department::where('is_deleted', 0)
                        ->get();

            $SS_nonactive = SparePart::where('sp_category', 'SS')->where('sp_status', 0)->where('is_deleted', 0)->count();
            $SS_active = SparePart::where('sp_category', 'SS')->where('sp_status', 1)->where('is_deleted', 0)->count();
            $SS_slow = SparePart::where('sp_category', 'SS')->where('sp_status', 2)->where('is_deleted', 0)->count();
            $ss_nonactive_percen = ($SS_nonactive / 100) * ($SS_nonactive + $SS_active + $SS_slow);
            $ss_active_percen = ($SS_active / 100) * ($SS_nonactive + $SS_active + $SS_slow);
            $ss_slow_percen = ($SS_slow / 100) * ($SS_nonactive + $SS_active + $SS_slow);

            $SK_nonactive = SparePart::where('sp_category', 'SK')->where('sp_status', 0)->where('is_deleted', 0)->count();
            $SK_active = SparePart::where('sp_category', 'SK')->where('sp_status', 1)->where('is_deleted', 0)->count();
            $SK_slow = SparePart::where('sp_category', 'SK')->where('sp_status', 2)->where('is_deleted', 0)->count();
            $sk_nonactive_percen = ($SK_nonactive / 100) * ($SK_nonactive + $SK_active + $SK_slow);
            $sk_active_percen = ($SK_active / 100) * ($SK_nonactive + $SK_active + $SK_slow);
            $sk_slow_percen = ($SK_slow / 100) * ($SK_nonactive + $SK_active + $SK_slow);

            $stockinout = StockInOut::join('spare_part', 'sp_id','=','si_sp_id')
                        ->join('users', 'id','=','si_who')
                        ->where('stock_inout.is_deleted', 0)
                        ->orderBy('stock_inout.created_at', 'DESC')
                        ->limit(5)
                        ->orderBy('si_id', 'DESC')
                        ->get();

            $low_stock = SparePart::join('supplier', 'supplier.supplier_id', '=', 'spare_part.sp_supplier_id')
                        ->whereColumn('spare_part.sp_opening_stock', '<=', 'spare_part.sp_min_stock')
                        ->where('spare_part.is_deleted', 0)
                        ->orderBy('sp_id', 'DESC')
                        ->get();

                        $exceed_budget = StockInOut::select(
                            'department.department_name',
                            'budget.budget_budget',
                            'budget.budget_month',
                            DB::raw('DATE_FORMAT(stock_inout.created_at, "%Y-%m") as month_year'),
                            DB::raw('SUM(stock_inout.si_total) as total_budget')
                        )
                        ->leftjoin('spare_part', 'spare_part.sp_id', '=', 'stock_inout.si_sp_id')
                        ->join('department', 'department.department_id', '=', 'spare_part.sp_department')
                        ->join('budget', 'budget.budget_department', '=', 'department.department_id')
                        ->where('spare_part.is_deleted', 0)
                        ->where('stock_inout.is_deleted', 0)
                        ->where('stock_inout.si_type', 'Stock In')
                        ->groupBy('spare_part.sp_department', 'department.department_name', 'budget.budget_budget', 'budget.budget_month', 'month_year')
                        ->havingRaw('SUM(stock_inout.si_total) > budget.budget_budget')
                        ->get();

            return view('dashboard')->with([
                'notification' => $notification,
                'new_notification' => $new_notification,
                'supply_count' => $supply_count,
                'department' => $department,
                'SS_nonactive_all' => $SS_nonactive,
                'SS_active_all' => $SS_active,
                'SS_slow_all' => $SS_slow,
                'ss_nonactive_percen_all' => $ss_nonactive_percen,
                'ss_active_percen_all' => $ss_active_percen,
                'ss_slow_percen_all' => $ss_slow_percen,
                'SK_nonactive_all' => $SK_nonactive,
                'SK_active_all' => $SK_active,
                'SK_slow_all' => $SK_slow,
                'sk_nonactive_percen_all' => $sk_nonactive_percen,
                'sk_active_percen_all' => $sk_active_percen,
                'sk_slow_percen_all' => $sk_slow_percen,
                'stockinout_all' => $stockinout,
                'low_stock_all' => $low_stock,
                'exceed_budget_all' => $exceed_budget
            ]);
        }
    }

    public function updateLowStock(Request $request, $sp_id)
    {
        $existingLowStock = Sparepart::where('sp_actiontaken', $request['sp_actiontaken'])
                            ->where('is_deleted', 0)
                            ->exists();


        $lowstock = SparePart::find($sp_id);
        $oriLowStock = $lowstock->sp_actiontaken;
        $lowstock->sp_actiontaken = $request['sp_actiontaken'];

        $lowstock->save();
        return redirect()->back();
    }
}
