<?php

namespace App\Http\Controllers;

use App\Models\Audit;
use App\Models\Budgetting;
use App\Models\Department;
use App\Models\Notifications;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BudgetController extends Controller
{
    public function showBudget(Request $request)
    {
        if(Auth::check()){

            $dropFilter = Budgetting::join('department', 'department_id', 'budget_department')
                        ->where('budget.is_deleted', 0);

            $budgetFilter = $dropFilter->pluck('budget_budget')->unique();
            $monthFilter = $dropFilter->pluck('budget_month')->unique();

            $filterDepartment = $request->input('department');
            $filterMonth = $request->input('month');
            $filterBudget = $request->input('budget');

            $query = Budgetting::join('department', 'department_id', 'budget_department')
                      ->where('budget.is_deleted', 0);

            if ($filterDepartment) {
                $query->where('department_id', $filterDepartment);
            }
            if ($filterMonth) {
                $query->where('budget_month', 'LIKE', '%'.$filterMonth.'%');
            }
            if ($filterBudget) {
                $query->where('budget_budget', $filterBudget);
            }

            $budget = $query->orderBy('budget_id', 'DESC')->get();

            $department = Department::where('is_deleted', 0)->orderBy('department_name', 'ASC')->get();
            // $budget = Budgetting::join('department', 'department_id', 'budget_department')
            //           ->where('budget.is_deleted', 0)
            //           ->orderBy('budget_id', 'DESC')
            //           ->get();
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('budgeting')->with([
                'department' => $department,
                'budgeting' => $budget,
                'notification' => $notification,
                'new_notification' => $new_notification,
                'filter_budget' => $budgetFilter,
                'filter_month' => $monthFilter
            ]);
        }
        return redirect()->to('login')->withSuccess('You are not allowed to access');

    }

    public function showEditBudget($budget_id)
    {
        if(Auth::check()){

            $department = Department::where('is_deleted', 0)->orderBy('department_name', 'ASC')->get();
            $budget = Budgetting::join('department', 'department_id','=','budget_department')
                    ->where('budget_id', $budget_id)->first();
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('edit-budget')->with([
                'department' => $department,
                'budgeting' => $budget,
                'notification' => $notification,
                'new_notification' => $new_notification,
            ]);
        }
        return redirect()->to('login')->withSuccess('You are not allowed to access');

    }

    public function showDepartment()
    {
        if(Auth::check()){

            $department = Department::where('is_deleted', 0)->orderBy('department_id', 'DESC')->get();
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('department')->with([
                'department' => $department,
                'notification' => $notification,
                'new_notification' => $new_notification,
            ]);
        }
        return redirect()->to('login')->withSuccess('You are not allowed to access');

    }

    public function addDepartment(Request $request)
    {
        $existingDepartment = Department::where('department_name', $request['department'])
                        ->where('is_deleted', 0)
                        ->exists();
        $existingDepartmentDeleted = Department::where('department_name', $request['department'])
                            ->where('is_deleted', 1)
                            ->exists();

        if ($existingDepartment) {
            return redirect()->back()->with('error_department1', "Department name ".$request['department']." already exists.");
        }
        if ($existingDepartmentDeleted) {
            return redirect()->back()->with('error_department2', "Department name ".$request['department']." already exists in restore module.");
        }

        $department = new Department();
        $department->department_name = $request['department'];
        $department->save();

        $audit = new Audit();
        $audit->at_module = 'Budgeting';
        $audit->at_submodule = 'Department';
        $audit->at_activity = 'Add Department';
        $audit->at_description = 'Added Department: '.$request['department'];
        $audit->at_user_id = Auth::user()->id;
        $audit->save();

        return redirect()->back();
    }

    public function addBudget(Request $request)
    {

        $budget = new Budgetting();
        $budget->budget_department = $request['department'];
        $budget->budget_month = $request['month'];
        $budget->budget_budget = $request['budget'];
        $budget->save();

        $audit = new Audit();
        $audit->at_module = 'Budgeting';
        $audit->at_submodule = 'Budgeting';
        $audit->at_activity = 'Add Budgeting';
        $audit->at_description = 'Add Budgeting on Department: '.$request['department']
                                .'<br>Amount: '.$request['budget']
                                .'<br>Month: '.$request['month'];
        $audit->at_user_id = Auth::user()->id;
        $audit->save();

        return redirect()->back();
    }

    public function updateBudget(Request $request, $budget_id)
    {
        $budget = Budgetting::join('department', 'department_id','=','budget_department')
                ->where('budget_id', $budget_id)->first();

        $originalDepartment = $budget->department_name;
        $newDepartment = Department::where('department_id', $request['department'])->value('department_name');
        $originalMonth = $budget->budget_month;
        $originalBudget = $budget->budget_budget;
        
        $budget->budget_department = $request['department'];
        $budget->budget_month = $request['month'];
        $budget->budget_budget = $request['budget'];

        $changes = [];

        // Compare and record changes
        if ($originalDepartment !== $request['department']) {
            $changes[] = "<br>Department changed from '$originalDepartment' to '$newDepartment'";
        }
        if ($originalMonth !== $request['month']) {
            $changes[] = "<br>Month changed from '$originalMonth' to '$request[month]'";
        }
        if ($originalBudget !== $request['budget']) {
            $changes[] = "<br>Budget changed from '$originalBudget' to '$request[budget]'";
        }

        // Create the audit description by joining the changes
        $auditDescription = 'Edited Budgeting: ' . implode(', ', $changes);

        if($changes != null){
            $audit = new Audit();
            $audit->at_module = 'Budgeting';
            $audit->at_submodule = 'Budgeting';
            $audit->at_activity = 'Edit Budgeting';
            $audit->at_description = $auditDescription;
            $audit->at_user_id = Auth::user()->id;
            $audit->save();
        }

        $budget->save();

        return redirect()->route('budgeting');

    }

    public function updateDepartment(Request $request, $department_id)
    {
        $existingDepartment = Department::where('department_name', $request['name'])
                        ->where('is_deleted', 0)
                        ->exists();
        $existingDepartmentDeleted = Department::where('department_name', $request['name'])
                            ->where('is_deleted', 1)
                            ->exists();

        if ($existingDepartment) {
            return redirect()->back()->with('error_department1', "Department name ".$request['name']." already exists.");
        }
        if ($existingDepartmentDeleted) {
            return redirect()->back()->with('error_department2', "Department name ".$request['name']." already exists in restore module.");
        }

        $department = Department::find($department_id);

        $originalDepartment = $department->department_name;
        $department->department_name = $request['name'];
        
        $changes = [];

        // Compare and record changes
        if ($originalDepartment !== $request['name']) {
            $changes[] = "<br>Department changed from '$originalDepartment' to '$request[name]'";
        }

        // Create the audit description by joining the changes
        $auditDescription = 'Edited Department: ' . implode(', ', $changes);

        if($changes != null){
            $audit = new Audit();
            $audit->at_module = 'Budgeting';
            $audit->at_submodule = 'Department';
            $audit->at_activity = 'Edit Department';
            $audit->at_description = $auditDescription;
            $audit->at_user_id = Auth::user()->id;
            $audit->save();
        }

        $department->save();

        return redirect()->back();

    }

    public function deleteDepartment($department_id)
    {
        $budget = Budgetting::where('budget_department', $department_id)->count();
        if($budget != 0){
            return redirect()->back()->with('error', 'This department possesses a budget for its operations.');
        }else{
            $department = Department::find($department_id);
            $department->is_deleted = 1;
            $department->save();
    
            $audit = new Audit();
            $audit->at_module = 'Budgeting';
            $audit->at_submodule = 'Department';
            $audit->at_activity = 'Delete Department';
            $audit->at_description = 'Deleted Department : '.$department->department_name;
            $audit->at_user_id = Auth::user()->id;
            $audit->save();
    
            return redirect()->back();
        }
    }

    public function deleteBudget($budget_id)
    {
        $budget = Budgetting::join('department', 'department_id', 'budget_department')->where('budget_id' ,$budget_id)->first();
        $budget->is_deleted = 1;
        $budget->save();

        $audit = new Audit();
        $audit->at_module = 'Budgeting';
        $audit->at_submodule = 'Budgeting';
        $audit->at_activity = 'Delete Budgeting';
        $audit->at_description = 'Deleted Budgeting on Department: '.$budget->department_name;
        $audit->at_user_id = Auth::user()->id;
        $audit->save();

        return redirect()->back();
    }

    public function restoreBudget($budget_id)
    {
        $budget = Budgetting::find($budget_id);
        $budget->is_deleted = 0;
        $budget->save();

        $audit = new Audit();
        $audit->at_module = 'Restore';
        $audit->at_submodule = 'Restore';
        $audit->at_activity = 'Restore Budget';
        $audit->at_description = 'Restore Budget: '.$budget->budget_month;
        $audit->at_user_id = Auth::user()->id;
        $audit->save();

        return redirect()->route('restore');
    }

    public function permanentDeleteBudget($budget_id)
    {
        $budget = Budgetting::find($budget_id);
        
        $audit = new Audit();
        $audit->at_module = 'Restore';
        $audit->at_submodule = 'Restore';
        $audit->at_activity = 'Delete Budget';
        $audit->at_description = 'Permanently Delete Budget: '.$budget->budget_month;
        $audit->at_user_id = Auth::user()->id;
        $audit->save();    
        
        $budget->delete();

        return redirect()->back();
    }

    public function restoreDepartment($department_id)
    {
        $department = Department::find($department_id);
        $department->is_deleted = 0;
        $department->save();

        $audit = new Audit();
        $audit->at_module = 'Restore';
        $audit->at_submodule = 'Restore';
        $audit->at_activity = 'Restore Department';
        $audit->at_description = 'Restore Department: '.$department->department_name;
        $audit->at_user_id = Auth::user()->id;
        $audit->save();

        return redirect()->back();
    }

    public function permanentDeleteDepartment($department_id)
    {
        $department = Department::find($department_id);

        $audit = new Audit();
        $audit->at_module = 'Restore';
        $audit->at_submodule = 'Restore';
        $audit->at_activity = 'Delete Department';
        $audit->at_description = 'Permanently Delete Department: '.$department->department_name;
        $audit->at_user_id = Auth::user()->id;
        $audit->save();    
        
        $department->delete();

        return redirect()->back();
    }

}
