<?php

namespace App\Http\Controllers;

use App\Models\Budgetting;
use App\Models\Department;
use App\Models\Notifications;
use App\Models\Role;
use App\Models\SparePart;
use App\Models\StockInOut;
use App\Models\Supplier;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie as FacadesCookie;
use Illuminate\Support\Facades\DB;

class AuthController extends Controller
{
    public function showRegistrationForm()
    {
        return view('auth.register');
    }
    
    public function showForgetPasswordForm() {
        return view('auth.resetpass');
    }

    public function showLoginForm() {
        return view('auth.login');
    }

    public function showProfile() {

        if(Auth::check()){
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('auth.profile')->with([
                'notification' => $notification,
                'new_notification' => $new_notification,
            ]);
        }

    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required',
        ]);
   
        $credentials = $request->only('username', 'password');
        if($request->has('rememberme')){
            FacadesCookie::queue('username', $request->username,1440);
            FacadesCookie::queue('password', $request->password,1440);
        }

        if (Auth::attempt($credentials, $request->has('remember'))) {
            $user = DB::table('users')->where('username', $request->username)->first();

            if($user->is_active != 0){
                return redirect()->intended('dashboard')
                        ->withSuccess('Signed in');
            }

            return redirect()->back()->with('non-active','User account doesnt active');

        }
        
        return redirect()->back()->with('username','Wrong username / password');

    }

    public function logout(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }

    public function resetPasswordForm(Request $request)
    {
        $user = User::all();
        $digit = $request['ic_no'];
        $foundUserId = null; 

        foreach ($user as $users) {
            $explode = explode("-", $users->ic_no);
            if ($explode[2] == $digit) {
                $foundUserId = $users->id;
                break; 
            }
        }

        if ($foundUserId !== null) {
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return view('auth.new-pass')->with([
                'id' => $foundUserId
            ]);
        } else {
            return back()->withErrors(['user' => 'error']);
        }

    }

    public function newPasswordForm(Request $request, $id)
    {
        $new_pass = $request['new_pass'];
        $confirm_pass = $request['confirm_pass'];

        if($new_pass == $confirm_pass){
            User::where('id', $id)->update([
                'password' => bcrypt($new_pass)
            ]);

            return view('auth.done-reset');
        }
        else{
            return back()->withErrors(['user' => 'error']);
        }
        
    }

    public function showRestore()
    {
        if(Auth::check()){

            $supplier = Supplier::where('is_deleted', 1)->orderBy('supplier_id', 'DESC')->get();
            $spare_part = SparePart::join('supplier', 'supplier_id','=','sp_supplier_id')
                                    ->join('department', 'department_id','=','sp_department')
                                    ->where('spare_part.is_deleted', 1)
                                    ->orderBy('sp_id', 'DESC')
                                    ->get();
            $out = StockInOut::select('stock_inout.si_id','spare_part.sp_series','spare_part.sp_die_name','stock_inout.si_itemlotno','spare_part.sp_desc','supplier.supplier_name','stock_inout.si_quantity','users.name','stock_inout.created_at','stock_inout.si_type')
                    ->join('spare_part', 'sp_id','=','si_sp_id')
                    ->join('supplier', 'supplier_id','sp_supplier_id')
                    ->join('users', 'id','=','si_who')
                    ->where('stock_inout.is_deleted', 1)
                    ->orderBy('si_id', 'DESC')
                    ->get();
            $budget = Budgetting::join('department', 'department_id', 'budget_department')->where('budget.is_deleted', 1)->orderBy('budget_id', 'DESC')->get();
            $department = Department::where('is_deleted', 1)->orderBy('department_id', 'DESC')->get();
            $role = Role::where('is_deleted', 1)->orderBy('ur_id', 'DESC')->get();
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('restore')->with([
                'supplier' => $supplier,
                'spare_part' => $spare_part,
                'out' => $out,
                'budgeting' => $budget,
                'department' => $department,
                'role' => $role,
                'notification' => $notification,
                'new_notification' => $new_notification,
            ]);
        }
  
        return redirect()->to('login')->withSuccess('You are not allowed to access');
    }

    public function showNotification()
    {
        if(Auth::check()){

            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();


            return view('notification')->with([
                'notification' => $notification,
                'new_notification' => $new_notification
            ]);
        }
    }

    public function deleteNotification(Request $request)
    {
        $list_id = $request["checkedBox"] ;
        if ($list_id != null ) {
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();
            foreach ($list_id as $id) {

                foreach ($notification as $notification_database){
                    if ( $notification_database->notification_id == $id )
                    {
                        $notification_database->delete();
                    }
                }
            }
        }

        return redirect()->route('notification');
    }

    public function markAsRead(Request $request)
    {
        $list_id = $request["checkedBox"] ;
        if ($list_id != null ) {
            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();
            foreach ($list_id as $id) {

                foreach ($notification as $notification_database){
                    if ( $notification_database->notification_id == $id )
                    {
                        if ( $notification_database->notification_is_read == 0 )
                        {
                            $notification_database->notification_is_read = 1;
                            $notification_database->update();
                        }
                    }

                }
            }
        }

        return redirect()->route('notification');
    }

    public function clickNotification($notification_id)
    {
        $read = Notifications::find($notification_id);
        $read->notification_is_read = 1;
        $read->save();

        return redirect()->route('addsinglestockin', $read->notification_sp_id);
    }
}
