<?php

namespace App\Http\Controllers;

use App\Models\Audit;
use App\Models\Notifications;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PDF;

class AuditController extends Controller
{
    public function showAuditTrail(Request $request)
    {
        if(Auth::check()){

            $filterActivity = $request->input('activity');
            $filterDescription = $request->input('description');
            $filterUser = $request->input('user');
            $from = $request['from'];
            $to = $request['to'];

            if($from != null && $to != null){

                $query = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id')
                        ->join('users', 'id','=','at_user_id')
                        ->where('audit_trail.created_at', '>=', $from)
                        ->where('audit_trail.created_at', '<=', $to);

            }elseif($from != null && $to == null){

                $query = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id')
                        ->join('users', 'id','=','at_user_id')
                        ->where('audit_trail.created_at', '>=', $from);

            }elseif($from == null && $to != null){

                $query = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id')
                        ->join('users', 'id','=','at_user_id')
                        ->where('audit_trail.created_at', '<=', $to);

            }else{

                $query = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id')
                        ->join('users', 'id','=','at_user_id');
            }

            if ($filterActivity && is_array($filterActivity) && !empty($filterActivity)) {
                $query->where(function ($q) use ($filterActivity) {
                    foreach ($filterActivity as $activity) {
                        $q->orWhere('at_activity', 'LIKE', '%' . $activity . '%');
                    }
                });
            }
            if ($filterDescription) {
                $query->where('at_description', 'LIKE', '%'.$filterDescription.'%');
            }
            if ($filterUser) {
                $query->where('id', $filterUser);
            }

            $audit = $query->orderBy('at_id', 'DESC')->get();

            $activityFilter = $query->pluck('at_activity')->unique();
            
            $user = User::where('is_active', 1)
                    ->orderBy('name', 'ASC')
                    ->get();

            $notification = Notifications::orderBy('notification_is_read', 'ASC')->get();
            $new_notification = Notifications::where('notification_is_read', 0)->count();

            return view('audit')->with([
               'audit' => $audit,
               'notification' => $notification,
               'new_notification' => $new_notification,
               'user' => $user,
               'filter_activity' => $activityFilter
            ]);
        }
        return redirect()->to('login')->withSuccess('You are not allowed to access');
    }

    public function downloadSingleAudit($at_id)
    {
        $data = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id','ad_description')
                ->join('users', 'id','=','at_user_id')
                ->leftJoin('audit_description', 'at_id','=','ad_audit_id')
                ->where('at_id', $at_id)
                ->get();
        $pdf = PDF::loadView('pdf.audit-pdf', compact('data'));
    
        return $pdf->download('audit_trail_'.$at_id.'.pdf');
    }

    public function downloadMultiAudit(Request $request)
    {
        $at_ids = $request->input('selectedValues');
        $ids = explode(',', $at_ids);
        if($at_ids == null){
            return redirect()->back()->with('error','Please choose data to generate first');
        }
        
        $data = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id','ad_description')
                ->join('users', 'id','=','at_user_id')
                ->leftJoin('audit_description', 'at_id','=','ad_audit_id')
                ->whereIn('at_id', $ids)
                ->get();

        $pdf = PDF::loadView('pdf.audit-pdf', compact('data'));

        return $pdf->download('multi_audit_trail.pdf');

    }

    public function downloadAllAudit()
    {
        $data = Audit::select('at_id','at_module','at_submodule','at_activity','at_description','at_user_id','audit_trail.created_at','name','id','ad_description')
                ->join('users', 'id','=','at_user_id')
                ->leftJoin('audit_description', 'at_id','=','ad_audit_id')
                ->get();

        $pdf = PDF::loadView('pdf.audit-pdf', compact('data'));

        return $pdf->download('all_audit_trail.pdf');
    }
}
