<?php
// app/Exports/MyExport.php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class InventoryExport implements FromCollection
{
    use Exportable;

    protected $data;
    protected $filePath;

    public function __construct(array $data)
    {
        $this->data = $data;    
    }

    public function collection()
    {
        $spreadsheet = IOFactory::load(public_path('template/SparePartReport.xlsx')); 
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('B10', $this->data['series']); 
        $sheet->setCellValue('C10', $this->data['die_name']); 
        $sheet->setCellValue('D10', $this->data['itemno']); 
        $sheet->setCellValue('E10', $this->data['description']); 
        $sheet->setCellValue('F10', $this->data['supplier']); 
        $sheet->setCellValue('G10', $this->data['unit_price']); 
        $sheet->setCellValue('H10', $this->data['opening_stock']); 
        $sheet->setCellValue('I10', $this->data['opening_amount']); 
        $sheet->setCellValue('J10', $this->data['stockin_qty']); 
        $sheet->setCellValue('K10', $this->data['stockin_amount']); 
        $sheet->setCellValue('L10', $this->data['stockout_qty']); 
        $sheet->setCellValue('M10', $this->data['stockout_amount']); 
        $sheet->setCellValue('N10', $this->data['closing_qty']); 
        $sheet->setCellValue('O10', $this->data['closing_amount']); 
        $sheet->setCellValue('P10', $this->data['status']); 
        $sheet->setCellValue('Q10', $this->data['latest_stockin_date']); 
        $sheet->setCellValue('R10', $this->data['latest_stockout_date']); 
        $sheet->setCellValue('S10', $this->data['month']); 
        $sheet->setCellValue('T10', $this->data['rank']); 

        $path = 'report/SparePart_report'.$this->data['sp_id'].'.xlsx';
        $this->filePath = public_path($path);

        $writer = new Xlsx($spreadsheet);
        $writer->save(public_path($path));


    }

    public function getFilePath()
    {
        return $this->filePath;
    }
}
