<?php

namespace App\Console\Commands;

use App\Models\ItemStatus;
use App\Models\SparePart;
use App\Models\StockInOut;
use Carbon\Carbon;
use DateTime;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class Rank extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rank:status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Change rank and status based on stock in/out activity';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $spare_part = SparePart::where('is_deleted', 0)->get();
        // $six_month = Carbon::now()->subMonths(6)->format('Y-m-d');
        // $one_year = Carbon::now()->subYear()->format('Y-m-d');
        // $two_year = Carbon::now()->subYears(2)->format('Y-m-d');
        // $four_year = Carbon::now()->subYears(4)->format('Y-m-d');

        //Time Value
        $active = ItemStatus::where('is_id', 1)->value('is_time');
        $slow_moving = ItemStatus::where('is_id', 2)->value('is_time');

        //Live
        $active_time = Carbon::now()->subMonths($active)->format('Y-m-d');
        $slow_moving_time = Carbon::now()->subMonths($slow_moving)->format('Y-m-d');

        //Testing
        $active_time2 = Carbon::now()->subDays($active)->format('Y-m-d G:i:s');
        $slow_moving_time2 = Carbon::now()->subDays($slow_moving)->format('Y-m-d G:i:s');

        foreach ($spare_part as $part) {

            //Testing
            $latestStockInOut = StockInOut::where('si_sp_id', $part->sp_id)->orderBy('created_at', 'DESC')->value('created_at');
            $latestStockInOutDate = new DateTime($latestStockInOut);
            $latestStockInOutDateFormat = $latestStockInOutDate->format('Y-m-d G:i:s');

            // Non need to use because admin manually update
            // if($latestStockInOut == null){
            //     $rank = $part->sp_rank;
            // }elseif($four_year > $latestStockInOutDateFormat){
            //     $rank = 'E';
            // }elseif($two_year > $latestStockInOutDateFormat && $four_year <= $latestStockInOutDateFormat){
            //     $rank = 'D';
            // }elseif($one_year > $latestStockInOutDateFormat && $two_year <= $latestStockInOutDateFormat){
            //     $rank = 'C';
            // }elseif($six_month > $latestStockInOutDateFormat && $one_year <= $latestStockInOutDateFormat){
            //     $rank = 'B';
            // }elseif($six_month <= $latestStockInOutDateFormat){
            //     $rank = 'A';
            // }

            // For Item Status (live) using months
            // if($latestStockInOut == null){
            //     $status = $part->sp_status;
            // }elseif($slow_moving_time >= $latestStockInOutDateFormat){
            //     $status = 0;
            // }elseif($active_time > $latestStockInOutDateFormat && $slow_moving_time <= $latestStockInOutDateFormat){
            //     $status = 2;
            // }elseif($active_time <= $latestStockInOutDateFormat){
            //     $status = 1;
            // }
            
            //Testing using days
            if($latestStockInOut == null){
                $status = $part->sp_status;
            }elseif($slow_moving_time2 >= $latestStockInOutDateFormat){
                $status = 0;
            }elseif($active_time2 > $latestStockInOutDateFormat && $slow_moving_time2 <= $latestStockInOutDateFormat){
                $status = 2;
            }elseif($active_time2 <= $latestStockInOutDateFormat){
                $status = 1;
            }

            // $part->sp_rank = $rank;
            $part->sp_status = $status;
            $part->save();
        }
    }
}
